"use strict";

Liferay.Loader.define("sharing-web$dom-helpers@5.2.0/cjs/transitionEnd", ['module', 'exports', 'require', '@sharing-web$babel/runtime/helpers/interopRequireDefault', './css', './listen'], function (module, exports, require) {
  var define = undefined;
  var _interopRequireDefault = require("@sharing-web$babel/runtime/helpers/interopRequireDefault");

  exports.__esModule = true;
  exports.default = transitionEnd;

  var _css = _interopRequireDefault(require("./css"));

  var _listen = _interopRequireDefault(require("./listen"));

  function parseDuration(node) {
    var str = (0, _css.default)(node, 'transitionDuration') || '';
    var mult = str.indexOf('ms') === -1 ? 1000 : 1;
    return parseFloat(str) * mult;
  }

  function triggerTransitionEnd(element) {
    var evt = document.createEvent('HTMLEvents');
    evt.initEvent('transitionend', true, true);
    element.dispatchEvent(evt);
  }

  function emulateTransitionEnd(element, duration, padding) {
    if (padding === void 0) {
      padding = 5;
    }

    var called = false;
    var handle = setTimeout(function () {
      if (!called) triggerTransitionEnd(element);
    }, duration + padding);
    var remove = (0, _listen.default)(element, 'transitionend', function () {
      called = true;
    }, {
      once: true
    });
    return function () {
      clearTimeout(handle);
      remove();
    };
  }

  function transitionEnd(element, handler, duration, padding) {
    if (duration == null) duration = parseDuration(element) || 0;
    var removeEmulate = emulateTransitionEnd(element, duration, padding);
    var remove = (0, _listen.default)(element, 'transitionend', handler);
    return function () {
      removeEmulate();
      remove();
    };
  }

  module.exports = exports["default"];
});
//# sourceMappingURL=transitionEnd.js.map