Liferay.Loader.define('sharing-web$lodash-es@4.17.15/max', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  import baseExtremum from './_baseExtremum.js';
  import baseGt from './_baseGt.js';
  import identity from './identity.js';

  /**
   * Computes the maximum value of `array`. If `array` is empty or falsey,
   * `undefined` is returned.
   *
   * @static
   * @since 0.1.0
   * @memberOf _
   * @category Math
   * @param {Array} array The array to iterate over.
   * @returns {*} Returns the maximum value.
   * @example
   *
   * _.max([4, 2, 8, 6]);
   * // => 8
   *
   * _.max([]);
   * // => undefined
   */
  function max(array) {
    return array && array.length ? baseExtremum(array, identity, baseGt) : undefined;
  }

  export default max;
});
//# sourceMappingURL=max.js.map