"use strict";

Liferay.Loader.define("sharing-web$dnd-core@10.0.1/dist/cjs/actions/dragDrop/endDrag", ['module', 'exports', 'require', '@sharing-web$react-dnd/invariant', './types'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = createEndDrag;

  var _invariant = require("@sharing-web$react-dnd/invariant");

  var _types = require("./types");

  function createEndDrag(manager) {
    return function endDrag() {
      var monitor = manager.getMonitor();
      var registry = manager.getRegistry();
      verifyIsDragging(monitor);
      var sourceId = monitor.getSourceId();
      var source = registry.getSource(sourceId, true);
      source.endDrag(monitor, sourceId);
      registry.unpinSource();
      return {
        type: _types.END_DRAG
      };
    };
  }

  function verifyIsDragging(monitor) {
    (0, _invariant.invariant)(monitor.isDragging(), 'Cannot call endDrag while not dragging.');
  }
});
//# sourceMappingURL=endDrag.js.map