Liferay.Loader.define("sharing-web@1.0.65/Sharing.es", ['module', 'exports', 'require', 'frontend-taglib-clay$clay-multi-select', 'frontend-taglib-clay$clay-sticker', 'frontend-js-web', 'frontend-js-metal-web$metal-dom', 'frontend-js-metal-web$metal-soy', 'frontend-js-metal-web$metal-state', './Sharing.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  require("frontend-taglib-clay$clay-multi-select");

  require("frontend-taglib-clay$clay-sticker");

  var _frontendJsWeb = require("frontend-js-web");

  var _metalDom = _interopRequireDefault(require("frontend-js-metal-web$metal-dom"));

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _Sharing = _interopRequireDefault(require("./Sharing.soy"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  var Sharing = /*#__PURE__*/function (_PortletBase) {
    _inherits(Sharing, _PortletBase);

    function Sharing(config) {
      var _getPrototypeOf2;

      var _this;

      _classCallCheck(this, Sharing);

      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }

      _this = _possibleConstructorReturn(this, (_getPrototypeOf2 = _getPrototypeOf(Sharing)).call.apply(_getPrototypeOf2, [this, config].concat(args)));
      _this._classNameId = config.classNameId;
      _this._classPK = config.classPK;
      _this._dialogId = config.dialogId;
      _this._refererPortletNamespace = config.refererPortletNamespace;
      _this._userEmailAddresses = [];
      return _this;
    }

    _createClass(Sharing, [{
      key: "attached",
      value: function attached() {
        var portalElement = _metalDom["default"].toElement('#clay_dropdown_portal');

        if (portalElement) {
          _metalDom["default"].addClasses(portalElement, 'show');
        }
      }
      /**
       * Fetches autocomplete results
       * @private
       * @review
       */

    }, {
      key: "_dataSource",
      value: function _dataSource(query) {
        var _this2 = this;

        return this.fetch(this.sharingUserAutocompleteURL, {
          query: query
        }).then(function (res) {
          return res.json();
        }).then(function (users) {
          return users.map(function (_ref) {
            var emailAddress = _ref.emailAddress,
                fullName = _ref.fullName,
                portraitURL = _ref.portraitURL,
                userId = _ref.userId;
            return {
              emailAddress: emailAddress,
              fullName: fullName,
              label: fullName,
              portraitURL: portraitURL,
              spritemap: _this2.spritemap,
              userId: userId,
              value: emailAddress
            };
          });
        });
      }
      /**
       * Disables filtering of results
       * @private
       * @review
       */

    }, {
      key: "_handleDataChange",
      value: function _handleDataChange(e) {
        e.preventDefault();

        if (e.data && e.target.refs.autocomplete._query) {
          e.target.filteredItems = e.data.map(function (element, index) {
            return {
              data: element,
              index: index,
              matches: [],
              score: 0,
              value: element
            };
          });
        } else {
          e.target.filteredItems = [];
        }

        e.target.refs.autocomplete._isFetching = false;
        e.target.refs.autocomplete.refs.dataProvider.isLoading = false;
      }
      /**
       * Close the SharingDialog
       * @private
       * @review
       */

    }, {
      key: "_closeDialog",
      value: function _closeDialog() {
        var sharingDialog = Liferay.Util.getWindow(this._dialogId);

        if (sharingDialog && sharingDialog.hide) {
          sharingDialog.hide();
        }
      }
      /**
       * Sync the inputs with the state
       * @param {!Event} event
       * @private
       * @review
       */

    }, {
      key: "_handleInputChange",
      value: function _handleInputChange(event) {
        var target = event.target;
        var name = target.name;
        var value = target.type === 'checkbox' ? target.checked : target.value;
        this[name] = value;
      }
      /**
       * Validates if the email addresses introduced is valid
       * and exists as a user.
       *
       * @param {!Event} event
       * @private
       * @review
       */

    }, {
      key: "_handleEmailAddressAdded",
      value: function _handleEmailAddressAdded(event) {
        var _this3 = this;

        var _event$data = event.data,
            item = _event$data.item,
            selectedItems = _event$data.selectedItems;
        this._userEmailAddresses = selectedItems;
        this.emailAddressErrorMessage = '';
        this._inputValue = '';
        var itemAdded = item.value;

        if (!this._isEmailAddressValid(itemAdded)) {
          this.emailAddressErrorMessage = Liferay.Language.get('please-enter-a-valid-email-address');
          this._inputValue = itemAdded;

          this._userEmailAddresses.pop();
        } else {
          this.fetch(this.sharingVerifyEmailAddressURL, {
            emailAddress: itemAdded
          }).then(function (response) {
            return response.json();
          }).then(function (result) {
            var userExists = result.userExists;

            if (!userExists) {
              _this3.emailAddressErrorMessage = Liferay.Util.sub(Liferay.Language.get('user-x-does-not-exist'), itemAdded);
              _this3._userEmailAddresses = _this3._userEmailAddresses.filter(function (item) {
                return item.value != itemAdded;
              });
              setTimeout(function () {
                _this3._inputValue = itemAdded;
              }, 0);
            }
          });
        }
      }
      /**
       * When input has been cleared removes the errors.
       *
       * @param  {!Event} event
       * @private
       * @review
       */

    }, {
      key: "_handleEmailInputChange",
      value: function _handleEmailInputChange(event) {
        if (!event.data.value) {
          this._inputValue = '';
          this.emailAddressErrorMessage = '';
        }
      }
      /**
       * Checks wether the input has emails or not.
       *
       * @param {!Event} event
       * @private
       * @review
       */

    }, {
      key: "_handleEmailRemoved",
      value: function _handleEmailRemoved(event) {
        this._userEmailAddresses = event.data.selectedItems;

        this._validateRequiredEmailAddress();
      }
      /**
       * Save the share permisions
       * @param {!Event} event
       * @private
       * @review
       */

    }, {
      key: "_handleSubmit",
      value: function _handleSubmit(event) {
        var _this4 = this;

        event.preventDefault();

        if (!this.submitting && this._validateRequiredEmailAddress()) {
          this.submitting = true;
          this.fetch(this.shareActionURL, {
            classNameId: this._classNameId,
            classPK: this._classPK,
            shareable: this.shareable,
            sharingEntryPermissionDisplayActionId: this.sharingEntryPermissionDisplayActionId,
            userEmailAddress: this._userEmailAddresses.map(function (_ref2) {
              var value = _ref2.value;
              return value;
            }).join(',')
          }).then(function (response) {
            _this4.submitting = false;
            var jsonResponse = response.json();
            return response.ok ? jsonResponse : jsonResponse.then(function (json) {
              var error = new Error(json.errorMessage || response.statusText);
              throw Object.assign(error, {
                response: response
              });
            });
          }).then(function (json) {
            parent.Liferay.Portlet.refresh("#p_p_id".concat(_this4._refererPortletNamespace));

            _this4._showNotification(json.successMessage);
          })["catch"](function (error) {
            _this4.submitting = false;

            _this4._showNotification(error.message, true);
          });
        }
      }
      /**
       * Show notification in the opener and closes dialog
       * after is rendered
       * @param {string} message message for notification
       * @param {boolean} error Flag indicating if is an error or not
       * @private
       * @review
       */

    }, {
      key: "_showNotification",
      value: function _showNotification(message, error) {
        var parentOpenToast = Liferay.Util.getOpener().Liferay.Util.openToast;
        var openToastParams = {
          events: {
            attached: this._closeDialog.bind(this)
          },
          message: message
        };

        if (error) {
          openToastParams.title = Liferay.Language.get('error');
          openToastParams.type = 'danger';
        }

        parentOpenToast(openToastParams);
      }
      /**
       * Check if a passed email has a valid format
       * @private
       * @review
       * @return {Boolean} is valid or not
       */

    }, {
      key: "_isEmailAddressValid",
      value: function _isEmailAddressValid(email) {
        var emailRegex = /.+@.+\..+/i;
        return emailRegex.test(email);
      }
      /**
       * Check if the userEmailAddresses is filled and show error message
       * @private
       * @review
       * @return {Boolean} is valid or not
       */

    }, {
      key: "_validateRequiredEmailAddress",
      value: function _validateRequiredEmailAddress() {
        var valid = !!this._userEmailAddresses.length;
        this.emailAddressErrorMessage = valid ? '' : Liferay.Language.get('this-field-is-required');
        return valid;
      }
    }]);

    return Sharing;
  }(_frontendJsWeb.PortletBase);
  /**
   * State definition.
   * @review
   * @static
   * @type {!Object}
   */

  Sharing.STATE = {
    _inputValue: _metalState.Config.string().internal(),
    emailAddressErrorMessage: _metalState.Config.string().value(''),
    shareActionURL: _metalState.Config.string().required(),
    shareable: _metalState.Config.bool().value(true),
    sharingEntryPermissionDisplayActionId: _metalState.Config.string().required(),
    sharingUserAutocompleteURL: _metalState.Config.string().required(),
    sharingVerifyEmailAddressURL: _metalState.Config.string().required(),
    spritemap: _metalState.Config.string().required(),
    submitting: _metalState.Config.bool().value(false)
  };

  _metalSoy["default"].register(Sharing, _Sharing["default"]);

  var _default = Sharing;
  exports["default"] = _default;
  //# sourceMappingURL=Sharing.es.js.map
});
//# sourceMappingURL=Sharing.es.js.map