Liferay.Loader.define("sharing-web@1.0.65/ManageCollaborators.es", ['module', 'exports', 'require', 'frontend-taglib-clay$clay-alert', 'frontend-taglib-clay$clay-button', 'frontend-taglib-clay$clay-select', 'frontend-taglib-clay$clay-sticker', 'frontend-js-web', 'frontend-js-metal-web$metal-soy', 'frontend-js-metal-web$metal-state', './ManageCollaborators.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  require("frontend-taglib-clay$clay-alert");

  require("frontend-taglib-clay$clay-button");

  require("frontend-taglib-clay$clay-select");

  require("frontend-taglib-clay$clay-sticker");

  var _frontendJsWeb = require("frontend-js-web");

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _ManageCollaborators = _interopRequireDefault(require("./ManageCollaborators.soy"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * Handles actions to delete or change permissions of the
   * collaborators for a file entry.
   */
  var ManageCollaborators = /*#__PURE__*/function (_PortletBase) {
    _inherits(ManageCollaborators, _PortletBase);

    function ManageCollaborators() {
      _classCallCheck(this, ManageCollaborators);

      return _possibleConstructorReturn(this, _getPrototypeOf(ManageCollaborators).apply(this, arguments));
    }

    _createClass(ManageCollaborators, [{
      key: "attached",

      /**
       * @inheritDoc
       */
      value: function attached() {
        this._deleteSharingEntryIds = [];
        this._sharingEntryIdsAndPermissions = {};
        this._sharingEntryIdsAndExpirationDate = {};
        this._sharingEntryIdsAndShareables = {};
        var tomorrow = new Date();
        tomorrow = tomorrow.setDate(tomorrow.getDate() + 1);
        this._tomorrowDate = new Date(tomorrow).toISOString().split('T')[0];
      }
      /**
       * Checks if the date is after today.
       * @param  {String} expirationDate
       * @protected
       *
       * @return {Bool} returns true if the expiration date
       * is after today, false in other case.
       */

    }, {
      key: "_checkExpirationDate",
      value: function _checkExpirationDate(expirationDate) {
        var date = new Date(expirationDate);
        return date >= new Date(this._tomorrowDate);
      }
      /**
       * Closes the dialog.
       * @protected
       */

    }, {
      key: "_closeDialog",
      value: function _closeDialog() {
        var collaboratorsDialog = Liferay.Util.getWindow(this._dialogId);

        if (collaboratorsDialog && collaboratorsDialog.hide) {
          collaboratorsDialog.hide();
        }
      }
    }, {
      key: "_convertToPair",
      value: function _convertToPair(sharingEntryObject) {
        var keys = Object.keys(sharingEntryObject);
        var result = [];
        keys.forEach(function (key) {
          result.push(key + ',' + sharingEntryObject[key]);
        });
        return result;
      }
      /**
       * Looks if there is a collaborator with an invalid
       * expiration date.
       *
       * @return {Boolean} If a collaborator has an invalid expiration date
       */

    }, {
      key: "_findExpirationDateError",
      value: function _findExpirationDateError() {
        var collaborator = this.collaborators.find(function (collaborator) {
          return collaborator.sharingEntryExpirationDateError === true;
        });
        this.expirationDateError = collaborator != null;
        return this.expirationDateError;
      }
      /**
       * Finds a collaborator by his id
       *
       * @param  {String} collaboratorId The id of a collaborator
       * @return {Object} Collaborator
       */

    }, {
      key: "_getCollaborator",
      value: function _getCollaborator(collaboratorId) {
        var collaboratorIdNumber = Number(collaboratorId);
        var collaborator = this.collaborators.find(function (collaborator) {
          return collaborator.userId === collaboratorIdNumber;
        });
        return collaborator;
      }
      /**
       * Closes the dialog.
       * @protected
       */

    }, {
      key: "_handleCancelButtonClick",
      value: function _handleCancelButtonClick() {
        this._closeDialog();
      }
      /**
       * Gets the new permission key for the selected
       * collaborator.
       *
       * @param {Event} event
       * @protected
       */

    }, {
      key: "_handleChangePermission",
      value: function _handleChangePermission(event) {
        var sharingEntryId = event.target.getAttribute('name');
        var sharingEntryPermissionKey = event.target.value;
        this._sharingEntryIdsAndPermissions[sharingEntryId] = sharingEntryPermissionKey;
      }
      /**
       * Gets the selected expiration date.
       *
       * @param {Event} event
       * @protected
       */

    }, {
      key: "_handleBlurExpirationDate",
      value: function _handleBlurExpirationDate(event) {
        var _this = this;

        var collaboratorId = event.target.dataset.collaboratorId;
        var sharingEntryExpirationDate = event.target.value;
        var sharingEntryId = event.target.dataset.sharingentryId;

        var collaborator = this._getCollaborator(collaboratorId);

        var dateError = !this._checkExpirationDate(sharingEntryExpirationDate);
        collaborator.sharingEntryExpirationDateError = dateError;

        if (!dateError) {
          collaborator.sharingEntryExpirationDateTooltip = this._getTooltipDate(sharingEntryExpirationDate);
          this._sharingEntryIdsAndExpirationDate[sharingEntryId] = sharingEntryExpirationDate;
        }

        this.collaborators = this.collaborators;
        setTimeout(function () {
          return _this._findExpirationDateError();
        }, 0);
      }
      /**
       * Get shareable permissions
       *
       * @param {Event} event
       * @protected
       */

    }, {
      key: "_handleChangeShareable",
      value: function _handleChangeShareable(event) {
        var target = event.delegateTarget;
        var collaboratorId = target.dataset.collaboratorId;
        var shareable = target.checked;
        var sharingEntryId = target.dataset.sharingentryId;

        var collaborator = this._getCollaborator(collaboratorId);

        if (collaborator) {
          collaborator.sharingEntryShareable = shareable;
          this.collaborators = this.collaborators;
        }

        this._sharingEntryIdsAndShareables[sharingEntryId] = shareable;
      }
      /**
       * Deletes the collaborator.
       *
       * @param {Event} event
       * @protected
       */

    }, {
      key: "_handleDeleteCollaborator",
      value: function _handleDeleteCollaborator(event) {
        var target = event.delegateTarget;
        var collaboratorId = Number(target.dataset.collaboratorId);
        var sharingEntryId = target.dataset.sharingentryId;
        event.stopPropagation();
        this.collaborators = this.collaborators.filter(function (collaborator) {
          return collaborator.userId != collaboratorId;
        });

        this._deleteSharingEntryIds.push(sharingEntryId);
      }
      /**
       * Enable and disable the expiration date field
       * @param  {Event} event
       * @protected
       */

    }, {
      key: "_handleEnableDisableExpirationDate",
      value: function _handleEnableDisableExpirationDate(event) {
        var target = event.delegateTarget;
        var collaboratorId = target.dataset.collaboratorId;
        var enabled = target.checked;

        var collaborator = this._getCollaborator(collaboratorId);

        if (collaborator) {
          var sharingEntryExpirationDate = enabled ? this._tomorrowDate : '';
          collaborator.enabledExpirationDate = enabled;

          if (!enabled) {
            collaborator.sharingEntryExpirationDateError = false;

            this._findExpirationDateError();
          }

          collaborator.sharingEntryExpirationDate = sharingEntryExpirationDate;
          collaborator.sharingEntryExpirationDateTooltip = this._getTooltipDate(sharingEntryExpirationDate);
          this._sharingEntryIdsAndExpirationDate[collaborator.sharingEntryId] = sharingEntryExpirationDate;
          this.collaborators = this.collaborators;
        }
      }
      /**
       * Expand configuration for sharing permissions and expiration
       *
       * @param {Event} event
       * @protected
       */

    }, {
      key: "_handleExpandCollaborator",
      value: function _handleExpandCollaborator(event) {

        if ('select,option,button'.indexOf(event.target.nodeName.toLowerCase()) == -1) {
          this.expandedCollaboratorId = event.delegateTarget.dataset.collaboratorid;
        }
      }
      /**
       * Sends a request to the server to update permissions
       * or delete collaborators.
       *
       * @protected
       */

    }, {
      key: "_handleSaveButtonClick",
      value: function _handleSaveButtonClick() {
        var _this2 = this;

        if (this._findExpirationDateError()) {
          return;
        }

        this.fetch(this.actionUrl, {
          deleteSharingEntryIds: this._deleteSharingEntryIds,
          sharingEntryIdActionIdPairs: this._convertToPair(this._sharingEntryIdsAndPermissions),
          sharingEntryIdExpirationDatePairs: this._convertToPair(this._sharingEntryIdsAndExpirationDate),
          sharingEntryIdShareablePairs: this._convertToPair(this._sharingEntryIdsAndShareables)
        }).then(function (response) {
          _this2.submitting = false;
          var jsonResponse = response.json();
          return response.ok ? jsonResponse : jsonResponse.then(function (json) {
            var error = new Error(json.errorMessage || response.statusText);
            throw Object.assign(error, {
              response: response
            });
          });
        }).then(function (json) {
          _this2._loadingResponse = false;

          _this2._showNotification(json.successMessage);
        })["catch"](function (error) {
          _this2._loadingResponse = false;

          _this2._showNotification(error.message, true);
        });
        this._loadingResponse = true;
      }
      /**
       * Get the formatted date that has to be shown
       * in the tooltip.
       *
       * @param  {Date} expirationDate [description]
       * @return {String}                [description]
       */

    }, {
      key: "_getTooltipDate",
      value: function _getTooltipDate(expirationDate) {
        return Liferay.Util.sub(Liferay.Language.get('until-x'), new Date(expirationDate).toLocaleDateString(Liferay.ThemeDisplay.getBCP47LanguageId()));
      }
      /**
       * Cleans the error.
       * @protected
       */

    }, {
      key: "_removeExpirationDateError",
      value: function _removeExpirationDateError() {
        this.expirationDateError = false;
      }
      /**
       * Show notification in the opener and closes dialog
       * after is rendered
       * @param {string} message message for notification
       * @param {boolean} error Flag indicating if is an error or not
       * @private
       * @review
       */

    }, {
      key: "_showNotification",
      value: function _showNotification(message, error) {
        var parentOpenToast = Liferay.Util.getOpener().Liferay.Util.openToast;
        var openToastParams = {
          events: {
            attached: this._closeDialog.bind(this)
          },
          message: message
        };

        if (error) {
          openToastParams.title = Liferay.Language.get('error');
          openToastParams.type = 'danger';
        }

        parentOpenToast(openToastParams);
      }
    }]);

    return ManageCollaborators;
  }(_frontendJsWeb.PortletBase);
  /**
   * State definition.
   * @ignore
   * @static
   * @type {!Object}
   */

  ManageCollaborators.STATE = {
    /**
     * Uri to send the manage collaborators fetch request.
     * @instance
     * @memberof ManageCollaborators
     * @type {String}
     */
    actionUrl: _metalState.Config.string().required(),

    /**
     * List of collaborators
     * @type {Array.<Object>}
     */
    collaborators: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
      fullName: _metalState.Config.string(),
      sharingEntryExpirationDate: _metalState.Config.string(),
      sharingEntryExpirationDateTooltip: _metalState.Config.string(),
      sharingEntryId: _metalState.Config.string(),
      sharingEntryPermissionDisplaySelectOptions: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
        label: _metalState.Config.string(),
        selected: _metalState.Config.bool(),
        value: _metalState.Config.string()
      })),
      sharingEntryShareable: _metalState.Config.bool(),
      userId: _metalState.Config.number()
    })).required(),

    /**
     * Id of the dialog
     * @type {String}
     */
    dialogId: _metalState.Config.string().required,

    /**
     * Id of the expanded collaborator
     * @memberof ManageCollaborators
     * @type {String}
     */
    expandedCollaboratorId: _metalState.Config.string(),

    /**
     * Path to images.
     * @instance
     * @memberof ManageCollaborators
     * @type {String}
     */
    spritemap: _metalState.Config.string().required()
  }; // Register component

  _metalSoy["default"].register(ManageCollaborators, _ManageCollaborators["default"]);

  var _default = ManageCollaborators;
  exports["default"] = _default;
  //# sourceMappingURL=ManageCollaborators.es.js.map
});
//# sourceMappingURL=ManageCollaborators.es.js.map