/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharing.test.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.test.context.ContextUserReplace;
import com.liferay.portal.kernel.test.rule.AggregateTestRule;
import com.liferay.portal.kernel.test.rule.DeleteAfterTestRun;
import com.liferay.portal.kernel.test.util.CompanyTestUtil;
import com.liferay.portal.kernel.test.util.GroupTestUtil;
import com.liferay.portal.kernel.test.util.ServiceContextTestUtil;
import com.liferay.portal.kernel.test.util.TestPropsValues;
import com.liferay.portal.kernel.test.util.UserTestUtil;
import com.liferay.portal.security.permission.contributor.PermissionSQLContributor;
import com.liferay.portal.test.rule.Inject;
import com.liferay.portal.test.rule.LiferayIntegrationTestRule;
import com.liferay.portal.test.rule.PermissionCheckerMethodTestRule;
import com.liferay.sharing.model.SharingEntry;
import com.liferay.sharing.security.permission.SharingEntryAction;
import com.liferay.sharing.security.permission.SharingPermissionChecker;
import com.liferay.sharing.service.SharingEntryLocalService;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

public abstract class BaseSharingTestCase<T extends ClassedModel> {
    @ClassRule
    @Rule
    public static final AggregateTestRule aggregateTestRule = new AggregateTestRule(new TestRule[]{new LiferayIntegrationTestRule(), PermissionCheckerMethodTestRule.INSTANCE});
    private static final Log _log = LogFactoryUtil.getLog(BaseSharingTestCase.class);
    @Inject
    private ClassNameLocalService _classNameLocalService;
    @DeleteAfterTestRun
    private Company _company;
    private Group _group;
    private User _groupUser;
    private Role _powerUserRole;
    @Inject
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Inject
    private RoleLocalService _roleLocalService;
    @Inject
    private SharingEntryLocalService _sharingEntryLocalService;
    private User _user;

    @Before
    public void setUp() throws Exception {
        this._company = CompanyTestUtil.addCompany();
        this._user = UserTestUtil.addCompanyAdminUser((Company)this._company);
        this._group = GroupTestUtil.addGroup((long)this._company.getCompanyId(), (long)this._user.getUserId(), (long)0L);
        this._groupUser = UserTestUtil.addGroupUser((Group)this._group, (String)"Power User");
        this._powerUserRole = this._roleLocalService.getRole(this._company.getCompanyId(), "Power User");
    }

    @Test
    public void testAdminCanShareWithAddDiscussion() throws Exception {
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)this._user);
        try (ContextUserReplace contextUserReplace = new ContextUserReplace(this._user, permissionChecker);){
            this._assertContainsSharingPermission(permissionChecker, this.getModel(this._user, this._group), SharingEntryAction.ADD_DISCUSSION);
        }
    }

    @Test
    public void testAdminCanShareWithUpdate() throws Exception {
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)this._user);
        try (ContextUserReplace contextUserReplace = new ContextUserReplace(this._user, permissionChecker);){
            this._assertContainsSharingPermission(permissionChecker, this.getModel(this._user, this._group), SharingEntryAction.UPDATE);
        }
    }

    @Test
    public void testAdminCanShareWithView() throws Exception {
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)this._user);
        try (ContextUserReplace contextUserReplace = new ContextUserReplace(this._user, permissionChecker);){
            this._assertContainsSharingPermission(permissionChecker, this.getModel(this._user, this._group), SharingEntryAction.VIEW);
        }
    }

    @Test
    public void testDeletingSharedModelDeletesSharingEntries() throws Exception {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this._group.getGroupId(), (long)this._user.getUserId());
        T model = this.getModel(this._user, this._group);
        long classPK = (Long)model.getPrimaryKeyObj();
        this._sharingEntryLocalService.addSharingEntry(this._user.getUserId(), this._groupUser.getUserId(), this._classNameLocalService.getClassNameId(model.getModelClassName()), classPK, this._group.getGroupId(), true, Arrays.asList(SharingEntryAction.UPDATE, SharingEntryAction.VIEW), null, serviceContext);
        List toUserSharingEntries = this._sharingEntryLocalService.getToUserSharingEntries(this._groupUser.getUserId());
        Assert.assertEquals((String)toUserSharingEntries.toString(), (long)1L, (long)toUserSharingEntries.size());
        this.deleteModel(model);
        toUserSharingEntries = this._sharingEntryLocalService.getToUserSharingEntries(this._groupUser.getUserId());
        Assert.assertEquals((String)toUserSharingEntries.toString(), (long)0L, (long)toUserSharingEntries.size());
    }

    @Test
    public void testDeletingSharedModelDoesNotDeleteOtherSharingEntries() throws Exception {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this._group.getGroupId(), (long)this._user.getUserId());
        T model1 = this.getModel(this._user, this._group);
        long classNameId1 = this._classNameLocalService.getClassNameId(model1.getModelClassName());
        long classPK1 = (Long)model1.getPrimaryKeyObj();
        this._sharingEntryLocalService.addSharingEntry(this._user.getUserId(), this._groupUser.getUserId(), classNameId1, classPK1, this._group.getGroupId(), true, Arrays.asList(SharingEntryAction.UPDATE, SharingEntryAction.VIEW), null, serviceContext);
        T model2 = this.getModel(this._user, this._group);
        long classNameId2 = this._classNameLocalService.getClassNameId(model2.getModelClassName());
        long classPK2 = (Long)model2.getPrimaryKeyObj();
        SharingEntry sharingEntry = this._sharingEntryLocalService.addSharingEntry(this._user.getUserId(), this._groupUser.getUserId(), classNameId2, classPK2, this._group.getGroupId(), true, Arrays.asList(SharingEntryAction.UPDATE, SharingEntryAction.VIEW), null, serviceContext);
        List toUserSharingEntries = this._sharingEntryLocalService.getToUserSharingEntries(this._groupUser.getUserId());
        Assert.assertEquals((String)toUserSharingEntries.toString(), (long)2L, (long)toUserSharingEntries.size());
        this.deleteModel(model1);
        toUserSharingEntries = this._sharingEntryLocalService.getToUserSharingEntries(this._groupUser.getUserId());
        Assert.assertEquals((String)toUserSharingEntries.toString(), (long)1L, (long)toUserSharingEntries.size());
        Assert.assertEquals((Object)sharingEntry, toUserSharingEntries.get(0));
    }

    @Test
    public void testInlinePermissions() throws Exception {
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)this._groupUser);
        try (ContextUserReplace contextUserReplace = new ContextUserReplace(this._groupUser, permissionChecker);){
            Assert.assertEquals((long)0L, (long)this.getModelCount(this._group));
            T model = this.getModel(TestPropsValues.getUser(), this._group);
            long classPK = (Long)model.getPrimaryKeyObj();
            this._sharingEntryLocalService.addSharingEntry(TestPropsValues.getUserId(), this._groupUser.getUserId(), this._classNameLocalService.getClassNameId(model.getModelClassName()), classPK, this._group.getGroupId(), true, Collections.singletonList(SharingEntryAction.VIEW), null, ServiceContextTestUtil.getServiceContext((long)this._group.getGroupId()));
            Assert.assertEquals((long)1L, (long)this.getModelCount(this._group));
        }
    }

    @Test
    public void testModelClassNameReturnsPermissionSQL() throws Exception {
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)TestPropsValues.getUser());
        try (ContextUserReplace contextUserReplace = new ContextUserReplace(TestPropsValues.getUser(), permissionChecker);){
            T model = this.getModel(TestPropsValues.getUser(), this._group);
            PermissionSQLContributor permissionSQLContributor = this.getPermissionSQLContributor();
            Assert.assertEquals((Object)StringBundler.concat((Object[])new Object[]{"1234 IN (SELECT SharingEntry.classPK FROM SharingEntry ", "WHERE (SharingEntry.toUserId = ", TestPropsValues.getUserId(), ") AND (SharingEntry.classNameId = ", this._classNameLocalService.getClassNameId(model.getModelClassName()), "))"}), (Object)permissionSQLContributor.getPermissionSQL(model.getModelClassName(), "1234", null, null, null));
        }
    }

    @Test
    public void testMovingToRecycleBinSharedModelDoesNotDeleteSharingEntries() throws Exception {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this._group.getGroupId(), (long)this._user.getUserId());
        T model = this.getModel(this._user, this._group);
        long classPK = (Long)model.getPrimaryKeyObj();
        this._sharingEntryLocalService.addSharingEntry(this._user.getUserId(), this._groupUser.getUserId(), this._classNameLocalService.getClassNameId(model.getModelClassName()), classPK, this._group.getGroupId(), true, Arrays.asList(SharingEntryAction.UPDATE, SharingEntryAction.VIEW), null, serviceContext);
        List toUserSharingEntries = this._sharingEntryLocalService.getToUserSharingEntries(this._groupUser.getUserId());
        Assert.assertEquals((String)toUserSharingEntries.toString(), (long)1L, (long)toUserSharingEntries.size());
        this.moveModelToTrash(model);
        toUserSharingEntries = this._sharingEntryLocalService.getToUserSharingEntries(this._groupUser.getUserId());
        Assert.assertEquals((String)toUserSharingEntries.toString(), (long)1L, (long)toUserSharingEntries.size());
    }

    @Test
    public void testUserWithAddDiscussionAndViewSharingEntryActionCanAddDiscussionPrivateModel() throws Exception {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this._group.getGroupId(), (long)this._user.getUserId());
        T model = this.getModel(this._user, this._group);
        long classPK = (Long)model.getPrimaryKeyObj();
        this._sharingEntryLocalService.addSharingEntry(this._user.getUserId(), this._groupUser.getUserId(), this._classNameLocalService.getClassNameId(model.getModelClassName()), classPK, this._group.getGroupId(), true, Arrays.asList(SharingEntryAction.ADD_DISCUSSION, SharingEntryAction.VIEW), null, serviceContext);
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)this._groupUser);
        try (ContextUserReplace contextUserReplace = new ContextUserReplace(this._groupUser, permissionChecker);){
            this._assertContainsPermission(permissionChecker, model, "ADD_DISCUSSION");
        }
    }

    @Test
    public void testUserWithAddDiscussionAndViewSharingEntryActionCannotUpdatePrivateModel() throws Exception {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this._group.getGroupId(), (long)this._user.getUserId());
        T model = this.getModel(this._user, this._group);
        long classPK = (Long)model.getPrimaryKeyObj();
        this._sharingEntryLocalService.addSharingEntry(this._user.getUserId(), this._groupUser.getUserId(), this._classNameLocalService.getClassNameId(model.getModelClassName()), classPK, this._group.getGroupId(), true, Arrays.asList(SharingEntryAction.ADD_DISCUSSION, SharingEntryAction.VIEW), null, serviceContext);
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)this._groupUser);
        try (ContextUserReplace contextUserReplace = new ContextUserReplace(this._groupUser, permissionChecker);){
            this._assertNotContainsPermission(permissionChecker, model, "UPDATE");
        }
    }

    @Test
    public void testUserWithAddDiscussionPermissionCannotShareWithUpdate() throws Exception {
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)this._groupUser);
        try (AddModelResourcePermission addModelResourcePermission = new AddModelResourcePermission(this._powerUserRole, "ADD_DISCUSSION");
             ContextUserReplace contextUserReplace = new ContextUserReplace(this._groupUser, permissionChecker);){
            this._assertNotContainsSharingPermission(permissionChecker, this.getModel(this._user, this._group), SharingEntryAction.UPDATE);
        }
    }

    @Test
    public void testUserWithAddDiscussionPermissionCannotShareWithView() throws Exception {
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)this._groupUser);
        try (AddModelResourcePermission addModelResourcePermission = new AddModelResourcePermission(this._powerUserRole, "ADD_DISCUSSION");
             ContextUserReplace contextUserReplace = new ContextUserReplace(this._groupUser, permissionChecker);){
            this._assertNotContainsSharingPermission(permissionChecker, this.getModel(this._user, this._group), SharingEntryAction.VIEW);
        }
    }

    @Test
    public void testUserWithAddDiscussionPermissionCanShareWithAddDiscussion() throws Exception {
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)this._groupUser);
        try (AddModelResourcePermission addModelResourcePermission = new AddModelResourcePermission(this._powerUserRole, "ADD_DISCUSSION");
             ContextUserReplace contextUserReplace = new ContextUserReplace(this._groupUser, permissionChecker);){
            this._assertContainsSharingPermission(permissionChecker, this.getModel(this._user, this._group), SharingEntryAction.ADD_DISCUSSION);
        }
    }

    @Test
    public void testUserWithoutAddDiscussionPermissionCannotShareWithAddDiscussion() throws Exception {
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)this._groupUser);
        try (ContextUserReplace contextUserReplace = new ContextUserReplace(this._groupUser, permissionChecker);){
            this._assertNotContainsSharingPermission(permissionChecker, this.getModel(this._user, this._group), SharingEntryAction.ADD_DISCUSSION);
        }
    }

    @Test
    public void testUserWithoutAddDiscussionSharingEntryActionCannotAddDiscussionPrivateModel() throws Exception {
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)this._groupUser);
        try (ContextUserReplace contextUserReplace = new ContextUserReplace(this._groupUser, permissionChecker);){
            this._assertNotContainsPermission(permissionChecker, this.getModel(this._user, this._group), "ADD_DISCUSSION");
        }
    }

    @Test
    public void testUserWithoutSharingCannotViewPrivateModel() throws Exception {
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)this._groupUser);
        try (ContextUserReplace contextUserReplace = new ContextUserReplace(this._groupUser, permissionChecker);){
            this._assertNotContainsPermission(permissionChecker, this.getModel(this._user, this._group), "VIEW");
        }
    }

    @Test
    public void testUserWithoutUpdatePermissionCannotShareWithUpdate() throws Exception {
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)this._groupUser);
        try (ContextUserReplace contextUserReplace = new ContextUserReplace(this._groupUser, permissionChecker);){
            this._assertNotContainsSharingPermission(permissionChecker, this.getModel(this._user, this._group), SharingEntryAction.UPDATE);
        }
    }

    @Test
    public void testUserWithoutUpdateSharingEntryActionCannotUpdatePrivateModel() throws Exception {
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)this._groupUser);
        try (ContextUserReplace contextUserReplace = new ContextUserReplace(this._groupUser, permissionChecker);){
            this._assertNotContainsPermission(permissionChecker, this.getModel(this._user, this._group), "UPDATE");
        }
    }

    @Test
    public void testUserWithoutViewPermissionCannotShareWithView() throws Exception {
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)this._groupUser);
        try (ContextUserReplace contextUserReplace = new ContextUserReplace(this._groupUser, permissionChecker);){
            this._assertNotContainsSharingPermission(permissionChecker, this.getModel(this._user, this._group), SharingEntryAction.VIEW);
        }
    }

    @Test
    public void testUserWithoutViewSharingEntryActionCannotViewPrivateModel() throws Exception {
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)this._groupUser);
        try (ContextUserReplace contextUserReplace = new ContextUserReplace(this._groupUser, permissionChecker);){
            this._assertNotContainsPermission(permissionChecker, this.getModel(this._user, this._group), "VIEW");
        }
    }

    @Test
    public void testUserWithUpdateAndViewSharingEntryActionCannotAddDiscussionPrivateModel() throws Exception {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this._group.getGroupId(), (long)this._user.getUserId());
        T model = this.getModel(this._user, this._group);
        long classPK = (Long)model.getPrimaryKeyObj();
        this._sharingEntryLocalService.addSharingEntry(this._user.getUserId(), this._groupUser.getUserId(), this._classNameLocalService.getClassNameId(model.getModelClassName()), classPK, this._group.getGroupId(), true, Arrays.asList(SharingEntryAction.UPDATE, SharingEntryAction.VIEW), null, serviceContext);
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)this._groupUser);
        try (ContextUserReplace contextUserReplace = new ContextUserReplace(this._groupUser, permissionChecker);){
            this._assertNotContainsPermission(permissionChecker, model, "ADD_DISCUSSION");
        }
    }

    @Test
    public void testUserWithUpdateAndViewSharingEntryActionCanUpdatePrivateModel() throws Exception {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this._group.getGroupId(), (long)this._user.getUserId());
        T model = this.getModel(this._user, this._group);
        long classPK = (Long)model.getPrimaryKeyObj();
        this._sharingEntryLocalService.addSharingEntry(this._user.getUserId(), this._groupUser.getUserId(), this._classNameLocalService.getClassNameId(model.getModelClassName()), classPK, this._group.getGroupId(), true, Arrays.asList(SharingEntryAction.UPDATE, SharingEntryAction.VIEW), null, serviceContext);
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)this._groupUser);
        try (ContextUserReplace contextUserReplace = new ContextUserReplace(this._groupUser, permissionChecker);){
            this._assertContainsPermission(permissionChecker, model, "UPDATE");
        }
    }

    @Test
    public void testUserWithUpdatePermissionCannotShareWithAddDiscussion() throws Exception {
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)this._groupUser);
        try (AddModelResourcePermission addModelResourcePermission = new AddModelResourcePermission(this._powerUserRole, "UPDATE");
             ContextUserReplace contextUserReplace = new ContextUserReplace(this._groupUser, permissionChecker);){
            this._assertNotContainsSharingPermission(permissionChecker, this.getModel(this._user, this._group), SharingEntryAction.ADD_DISCUSSION);
        }
    }

    @Test
    public void testUserWithUpdatePermissionCannotShareWithView() throws Exception {
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)this._groupUser);
        try (AddModelResourcePermission addModelResourcePermission = new AddModelResourcePermission(this._powerUserRole, "UPDATE");
             ContextUserReplace contextUserReplace = new ContextUserReplace(this._groupUser, permissionChecker);){
            this._assertNotContainsSharingPermission(permissionChecker, this.getModel(this._user, this._group), SharingEntryAction.VIEW);
        }
    }

    @Test
    public void testUserWithUpdatePermissionCanShareWithUpdate() throws Exception {
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)this._groupUser);
        try (AddModelResourcePermission addModelResourcePermission = new AddModelResourcePermission(this._powerUserRole, "UPDATE");
             ContextUserReplace contextUserReplace = new ContextUserReplace(this._groupUser, permissionChecker);){
            this._assertContainsSharingPermission(permissionChecker, this.getModel(this._user, this._group), SharingEntryAction.UPDATE);
        }
    }

    @Test
    public void testUserWithViewPermissionCannotShareWithAddDiscussion() throws Exception {
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)this._groupUser);
        try (AddModelResourcePermission addModelResourcePermission = new AddModelResourcePermission(this._powerUserRole, "VIEW");
             ContextUserReplace contextUserReplace = new ContextUserReplace(this._groupUser, permissionChecker);){
            this._assertNotContainsSharingPermission(permissionChecker, this.getModel(this._user, this._group), SharingEntryAction.ADD_DISCUSSION);
        }
    }

    @Test
    public void testUserWithViewPermissionCannotShareWithUpdate() throws Exception {
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)this._groupUser);
        try (AddModelResourcePermission addModelResourcePermission = new AddModelResourcePermission(this._powerUserRole, "VIEW");
             ContextUserReplace contextUserReplace = new ContextUserReplace(this._groupUser, permissionChecker);){
            this._assertNotContainsSharingPermission(permissionChecker, this.getModel(this._user, this._group), SharingEntryAction.UPDATE);
        }
    }

    @Test
    public void testUserWithViewPermissionCanShareWithView() throws Exception {
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)this._groupUser);
        try (AddModelResourcePermission addModelResourcePermission = new AddModelResourcePermission(this._powerUserRole, "VIEW");
             ContextUserReplace contextUserReplace = new ContextUserReplace(this._groupUser, permissionChecker);){
            this._assertContainsSharingPermission(permissionChecker, this.getModel(this._user, this._group), SharingEntryAction.VIEW);
        }
    }

    @Test
    public void testUserWithViewSharingEntryActionCannotViewPendingModel() throws Exception {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this._group.getGroupId(), (long)this._user.getUserId());
        T model = this.getPendingModel(this._user, this._group);
        long classPK = (Long)model.getPrimaryKeyObj();
        this._sharingEntryLocalService.addSharingEntry(this._user.getUserId(), this._groupUser.getUserId(), this._classNameLocalService.getClassNameId(model.getModelClassName()), classPK, this._group.getGroupId(), true, Arrays.asList(SharingEntryAction.VIEW), null, serviceContext);
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)this._groupUser);
        try (ContextUserReplace contextUserReplace = new ContextUserReplace(this._groupUser, permissionChecker);){
            this._assertNotContainsPermission(permissionChecker, model, "VIEW");
        }
    }

    @Test
    public void testUserWithViewSharingEntryActionCanViewPrivateModel() throws Exception {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this._group.getGroupId(), (long)this._user.getUserId());
        T model = this.getModel(this._user, this._group);
        long classPK = (Long)model.getPrimaryKeyObj();
        this._sharingEntryLocalService.addSharingEntry(this._user.getUserId(), this._groupUser.getUserId(), this._classNameLocalService.getClassNameId(model.getModelClassName()), classPK, this._group.getGroupId(), true, Arrays.asList(SharingEntryAction.VIEW), null, serviceContext);
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)this._groupUser);
        try (ContextUserReplace contextUserReplace = new ContextUserReplace(this._groupUser, permissionChecker);){
            this._assertContainsPermission(permissionChecker, model, "VIEW");
        }
    }

    protected abstract void deleteModel(T var1) throws PortalException;

    protected abstract String getClassName();

    protected abstract T getModel(User var1, Group var2) throws PortalException;

    protected abstract int getModelCount(Group var1) throws PortalException;

    protected abstract ModelResourcePermission<T> getModelResourcePermission();

    protected abstract T getPendingModel(User var1, Group var2) throws PortalException;

    protected abstract PermissionSQLContributor getPermissionSQLContributor();

    protected abstract SharingPermissionChecker getSharingPermissionChecker();

    protected abstract void moveModelToTrash(T var1) throws PortalException;

    private void _assertContainsPermission(PermissionChecker permissionChecker, T model, String actionId) throws PortalException {
        ModelResourcePermission<T> modelResourcePermission = this.getModelResourcePermission();
        Assert.assertTrue((boolean)modelResourcePermission.contains(permissionChecker, model, actionId));
    }

    private void _assertContainsSharingPermission(PermissionChecker permissionChecker, T model, SharingEntryAction sharingEntryAction) throws PortalException {
        SharingPermissionChecker sharingPermissionChecker = this.getSharingPermissionChecker();
        Assert.assertTrue((boolean)sharingPermissionChecker.hasPermission(permissionChecker, ((Long)model.getPrimaryKeyObj()).longValue(), this._group.getGroupId(), Collections.singletonList(sharingEntryAction)));
    }

    private void _assertNotContainsPermission(PermissionChecker permissionChecker, T model, String actionId) throws PortalException {
        ModelResourcePermission<T> modelResourcePermission = this.getModelResourcePermission();
        Assert.assertFalse((boolean)modelResourcePermission.contains(permissionChecker, model, actionId));
    }

    private void _assertNotContainsSharingPermission(PermissionChecker permissionChecker, T model, SharingEntryAction sharingEntryAction) throws PortalException {
        SharingPermissionChecker sharingPermissionChecker = this.getSharingPermissionChecker();
        Assert.assertFalse((boolean)sharingPermissionChecker.hasPermission(permissionChecker, ((Long)model.getPrimaryKeyObj()).longValue(), this._group.getGroupId(), Collections.singletonList(sharingEntryAction)));
    }

    private class AddModelResourcePermission
    implements AutoCloseable {
        private final String[] _actionKeys;
        private final Role _role;

        public AddModelResourcePermission(Role role, String ... actionKeys) {
            this._role = role;
            this._actionKeys = actionKeys;
            for (String actionKey : actionKeys) {
                try {
                    BaseSharingTestCase.this._resourcePermissionLocalService.addResourcePermission(role.getCompanyId(), BaseSharingTestCase.this.getClassName(), 3, String.valueOf(0L), role.getRoleId(), actionKey);
                }
                catch (PortalException portalException) {
                    _log.error((Throwable)portalException);
                }
            }
        }

        @Override
        public void close() throws Exception {
            for (String actionKey : this._actionKeys) {
                BaseSharingTestCase.this._resourcePermissionLocalService.removeResourcePermission(this._role.getCompanyId(), BaseSharingTestCase.this.getClassName(), 3, String.valueOf(0L), this._role.getRoleId(), actionKey);
            }
        }
    }
}

