/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharing.document.library.internal.display.context;

import com.liferay.document.library.display.context.DLDisplayContextFactory;
import com.liferay.document.library.display.context.DLEditFileEntryDisplayContext;
import com.liferay.document.library.display.context.DLViewFileVersionDisplayContext;
import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.sharing.configuration.SharingConfiguration;
import com.liferay.sharing.configuration.SharingConfigurationFactory;
import com.liferay.sharing.display.context.util.SharingMenuItemFactory;
import com.liferay.sharing.display.context.util.SharingToolbarItemFactory;
import com.liferay.sharing.document.library.internal.display.context.SharingDLViewFileVersionDisplayContext;
import com.liferay.sharing.document.library.internal.security.permission.SharingPermissionHelper;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DLDisplayContextFactory.class})
public class SharingDLDisplayContextFactory
implements DLDisplayContextFactory {
    @Reference
    private SharingConfigurationFactory _sharingConfigurationFactory;
    @Reference
    private SharingMenuItemFactory _sharingMenuItemFactory;
    @Reference
    private SharingPermissionHelper _sharingPermissionHelper;
    @Reference
    private SharingToolbarItemFactory _sharingToolbarItemFactory;

    public DLEditFileEntryDisplayContext getDLEditFileEntryDisplayContext(DLEditFileEntryDisplayContext parentDLEditFileEntryDisplayContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, DLFileEntryType dlFileEntryType) {
        return parentDLEditFileEntryDisplayContext;
    }

    public DLEditFileEntryDisplayContext getDLEditFileEntryDisplayContext(DLEditFileEntryDisplayContext parentDLEditFileEntryDisplayContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FileEntry fileEntry) {
        return parentDLEditFileEntryDisplayContext;
    }

    public DLViewFileVersionDisplayContext getDLViewFileVersionDisplayContext(DLViewFileVersionDisplayContext parentDLViewFileVersionDisplayContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FileShortcut fileShortcut) {
        return parentDLViewFileVersionDisplayContext;
    }

    public DLViewFileVersionDisplayContext getDLViewFileVersionDisplayContext(DLViewFileVersionDisplayContext parentDLViewFileVersionDisplayContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FileVersion fileVersion) {
        try {
            ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            SharingConfiguration sharingConfiguration = this._sharingConfigurationFactory.getGroupSharingConfiguration(themeDisplay.getSiteGroup());
            if (!sharingConfiguration.isEnabled()) {
                return parentDLViewFileVersionDisplayContext;
            }
            FileEntry fileEntry = null;
            if (fileVersion != null) {
                fileEntry = fileVersion.getFileEntry();
            }
            return new SharingDLViewFileVersionDisplayContext(parentDLViewFileVersionDisplayContext, httpServletRequest, httpServletResponse, fileEntry, fileVersion, ResourceBundleUtil.getBundle((Locale)themeDisplay.getLocale(), SharingDLDisplayContextFactory.class), this._sharingMenuItemFactory, this._sharingToolbarItemFactory, this._sharingPermissionHelper, sharingConfiguration);
        }
        catch (PortalException pe) {
            throw new SystemException("Unable to create sharing document library view file version display context for file version " + fileVersion, (Throwable)pe);
        }
    }
}

