/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.server.admin.web.internal.portlet.action;

import com.liferay.document.library.kernel.util.DLPreviewableProcessor;
import com.liferay.mail.kernel.service.MailService;
import com.liferay.petra.log4j.Log4JUtil;
import com.liferay.portal.convert.ConvertException;
import com.liferay.portal.convert.ConvertProcess;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.cache.MultiVMPool;
import com.liferay.portal.kernel.cache.SingleVMPool;
import com.liferay.portal.kernel.image.GhostscriptUtil;
import com.liferay.portal.kernel.image.ImageMagickUtil;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncPrintWriter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.log.SanitizerLogWrapper;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.portlet.LiferayActionResponse;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.scripting.Scripting;
import com.liferay.portal.kernel.scripting.ScriptingException;
import com.liferay.portal.kernel.scripting.ScriptingHelperUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.membershippolicy.OrganizationMembershipPolicy;
import com.liferay.portal.kernel.security.membershippolicy.OrganizationMembershipPolicyFactory;
import com.liferay.portal.kernel.security.membershippolicy.RoleMembershipPolicy;
import com.liferay.portal.kernel.security.membershippolicy.RoleMembershipPolicyFactory;
import com.liferay.portal.kernel.security.membershippolicy.SiteMembershipPolicy;
import com.liferay.portal.kernel.security.membershippolicy.SiteMembershipPolicyFactory;
import com.liferay.portal.kernel.security.membershippolicy.UserGroupMembershipPolicy;
import com.liferay.portal.kernel.security.membershippolicy.UserGroupMembershipPolicyFactory;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ServiceComponentLocalService;
import com.liferay.portal.kernel.servlet.DirectServletRegistry;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.ThreadUtil;
import com.liferay.portal.kernel.util.UnsyncPrintWriterPool;
import com.liferay.portal.kernel.xuggler.XugglerInstallException;
import com.liferay.portal.kernel.xuggler.XugglerUtil;
import com.liferay.portal.util.MaintenanceUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.ShutdownUtil;
import com.liferay.portlet.admin.util.CleanUpPermissionsUtil;
import com.liferay.portlet.admin.util.CleanUpPortletPreferencesUtil;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import org.apache.log4j.Level;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"javax.portlet.name=com_liferay_server_admin_web_portlet_ServerAdminPortlet", "mvc.command.name=/server_admin/edit_server"}, service={MVCActionCommand.class})
public class EditServerMVCActionCommand
extends BaseMVCActionCommand {
    private static final Log _log = LogFactoryUtil.getLog(EditServerMVCActionCommand.class);
    @Reference
    private DirectServletRegistry _directServletRegistry;
    @Reference
    private MailService _mailService;
    @Reference
    private MultiVMPool _multiVMPool;
    @Reference
    private OrganizationMembershipPolicyFactory _organizationMembershipPolicyFactory;
    @Reference
    private RoleMembershipPolicyFactory _roleMembershipPolicyFactory;
    @Reference
    private Scripting _scripting;
    @Reference
    private ServiceComponentLocalService _serviceComponentLocalService;
    @Reference
    private SingleVMPool _singleVMPool;
    @Reference
    private SiteMembershipPolicyFactory _siteMembershipPolicyFactory;
    @Reference
    private UserGroupMembershipPolicyFactory _userGroupMembershipPolicyFactory;

    public void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        if (!permissionChecker.isOmniadmin()) {
            SessionErrors.add((PortletRequest)actionRequest, (String)PrincipalException.MustBeOmniadmin.class.getName());
            actionResponse.setRenderParameter("mvcPath", "/error.jsp");
            return;
        }
        PortletPreferences portletPreferences = PrefsPropsUtil.getPreferences();
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
        if (cmd.equals("addLogLevel")) {
            this.addLogLevel(actionRequest);
        } else if (cmd.equals("cacheDb")) {
            this.cacheDb();
        } else if (cmd.equals("cacheMulti")) {
            this.cacheMulti();
        } else if (cmd.equals("cacheServlet")) {
            this.cacheServlet();
        } else if (cmd.equals("cacheSingle")) {
            this.cacheSingle();
        } else if (cmd.equals("cleanUpPermissions")) {
            CleanUpPermissionsUtil.cleanUpAddToPagePermissions((ActionRequest)actionRequest);
        } else if (cmd.equals("cleanUpPortletPreferences")) {
            CleanUpPortletPreferencesUtil.cleanUpLayoutRevisionPortletPreferences();
        } else if (cmd.startsWith("convertProcess.")) {
            redirect = this.convertProcess(actionRequest, actionResponse, cmd);
        } else if (cmd.equals("dlPreviews")) {
            DLPreviewableProcessor.deleteFiles();
        } else if (cmd.equals("gc")) {
            this.gc();
        } else if (cmd.equals("installXuggler")) {
            try {
                this.installXuggler(actionRequest, actionResponse);
            }
            catch (XugglerInstallException xie) {
                SessionErrors.add((PortletRequest)actionRequest, (String)XugglerInstallException.class.getName(), (Object)((Object)xie));
            }
        } else if (cmd.equals("runScript")) {
            this.runScript(actionRequest, actionResponse);
        } else if (cmd.equals("shutdown")) {
            this.shutdown(actionRequest);
        } else if (cmd.equals("threadDump")) {
            this.threadDump();
        } else if (cmd.equals("updateExternalServices")) {
            this.updateExternalServices(actionRequest, portletPreferences);
        } else if (cmd.equals("updateLogLevels")) {
            this.updateLogLevels(actionRequest);
        } else if (cmd.equals("updateMail")) {
            this.updateMail(actionRequest, portletPreferences);
        } else if (cmd.equals("verifyMembershipPolicies")) {
            this.verifyMembershipPolicies();
        } else if (cmd.equals("verifyPluginTables")) {
            this.verifyPluginTables();
        }
        this.sendRedirect(actionRequest, actionResponse, redirect);
    }

    protected void addLogLevel(ActionRequest actionRequest) throws Exception {
        String loggerName = ParamUtil.getString((PortletRequest)actionRequest, (String)"loggerName");
        String priority = ParamUtil.getString((PortletRequest)actionRequest, (String)"priority");
        Log4JUtil.setLevel((String)loggerName, (String)priority, (boolean)true);
    }

    protected void cacheDb() throws Exception {
        CacheRegistryUtil.clear();
    }

    protected void cacheMulti() throws Exception {
        this._multiVMPool.clear();
    }

    protected void cacheServlet() throws Exception {
        this._directServletRegistry.clearServlets();
    }

    protected void cacheSingle() throws Exception {
        this._singleVMPool.clear();
    }

    protected String convertProcess(ActionRequest actionRequest, ActionResponse actionResponse, String cmd) throws Exception {
        String className = StringUtil.replaceFirst((String)cmd, (String)"convertProcess.", (String)"");
        ConvertProcess convertProcess = (ConvertProcess)InstancePool.get((String)className);
        String[] parameters = convertProcess.getParameterNames();
        if (parameters != null) {
            String[] values = new String[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                String parameter = className + "." + parameters[i];
                if (parameters[i].contains("=")) {
                    String[] parameterPair = StringUtil.split((String)parameters[i], (char)'=');
                    parameter = className + "." + parameterPair[0];
                }
                values[i] = ParamUtil.getString((PortletRequest)actionRequest, (String)parameter);
            }
            convertProcess.setParameterValues(values);
        }
        try {
            convertProcess.validate();
        }
        catch (ConvertException ce) {
            SessionErrors.add((PortletRequest)actionRequest, ((Object)((Object)ce)).getClass(), (Object)((Object)ce));
            return null;
        }
        String path = convertProcess.getPath();
        if (path != null) {
            LiferayActionResponse liferayActionResponse = (LiferayActionResponse)actionResponse;
            PortletURL portletURL = liferayActionResponse.createRenderURL();
            portletURL.setParameter("mvcRenderCommandName", path);
            portletURL.setWindowState(WindowState.MAXIMIZED);
            return portletURL.toString();
        }
        PortletSession portletSession = actionRequest.getPortletSession();
        MaintenanceUtil.maintain((String)portletSession.getId(), (String)className);
        MessageBusUtil.sendMessage((String)"liferay/convert_process", (Object)className);
        return null;
    }

    protected void gc() throws Exception {
        Runtime runtime = Runtime.getRuntime();
        runtime.gc();
    }

    protected String getFileExtensions(ActionRequest actionRequest, String name) {
        String value = ParamUtil.getString((PortletRequest)actionRequest, (String)name);
        return value.replace(", .", ",.");
    }

    protected void installXuggler(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String jarName = ParamUtil.getString((PortletRequest)actionRequest, (String)"jarName");
        XugglerUtil.installNativeLibraries((String)jarName);
    }

    protected void runScript(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String language = ParamUtil.getString((PortletRequest)actionRequest, (String)"language");
        String script = ParamUtil.getString((PortletRequest)actionRequest, (String)"script");
        PortletConfig portletConfig = this.getPortletConfig((PortletRequest)actionRequest);
        PortletContext portletContext = portletConfig.getPortletContext();
        Map portletObjects = ScriptingHelperUtil.getPortletObjects((PortletConfig)portletConfig, (PortletContext)portletContext, (PortletRequest)actionRequest, (PortletResponse)actionResponse);
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        UnsyncPrintWriter unsyncPrintWriter = UnsyncPrintWriterPool.borrow((OutputStream)unsyncByteArrayOutputStream);
        portletObjects.put("out", unsyncPrintWriter);
        try {
            SessionMessages.add((PortletRequest)actionRequest, (String)"language", (Object)language);
            SessionMessages.add((PortletRequest)actionRequest, (String)"script", (Object)script);
            this._scripting.exec(null, portletObjects, language, script);
            unsyncPrintWriter.flush();
            SessionMessages.add((PortletRequest)actionRequest, (String)"scriptOutput", (Object)unsyncByteArrayOutputStream.toString());
        }
        catch (ScriptingException se) {
            SessionErrors.add((PortletRequest)actionRequest, (String)ScriptingException.class.getName(), (Object)((Object)se));
            Log log = SanitizerLogWrapper.allowCRLF((Log)_log);
            log.error((Object)se.getMessage());
        }
    }

    protected void shutdown(ActionRequest actionRequest) throws Exception {
        if (ShutdownUtil.isInProcess()) {
            ShutdownUtil.cancel();
        } else {
            long minutes = (long)ParamUtil.getInteger((PortletRequest)actionRequest, (String)"minutes") * 60000L;
            if (minutes <= 0L) {
                SessionErrors.add((PortletRequest)actionRequest, (String)"shutdownMinutes");
            } else {
                String message = ParamUtil.getString((PortletRequest)actionRequest, (String)"message");
                ShutdownUtil.shutdown((long)minutes, (String)message);
            }
        }
    }

    protected void threadDump() throws Exception {
        if (_log.isInfoEnabled()) {
            Log log = SanitizerLogWrapper.allowCRLF((Log)_log);
            log.info((Object)ThreadUtil.threadDump());
        } else {
            Class<?> clazz = ((Object)((Object)this)).getClass();
            _log.error((Object)("Thread dumps require the log level to be at least INFO for " + clazz.getName()));
        }
    }

    protected void updateExternalServices(ActionRequest actionRequest, PortletPreferences portletPreferences) throws Exception {
        boolean imageMagickEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"imageMagickEnabled");
        String imageMagickPath = ParamUtil.getString((PortletRequest)actionRequest, (String)"imageMagickPath");
        boolean xugglerEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"xugglerEnabled");
        portletPreferences.setValue("imagemagick.enabled", String.valueOf(imageMagickEnabled));
        portletPreferences.setValue("imagemagick.global.search.path", imageMagickPath);
        portletPreferences.setValue("xuggler.enabled", String.valueOf(xugglerEnabled));
        Enumeration enu = actionRequest.getParameterNames();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            if (!name.startsWith("imageMagickLimit")) continue;
            String key = StringUtil.toLowerCase((String)name.substring(16));
            String value = ParamUtil.getString((PortletRequest)actionRequest, (String)name);
            portletPreferences.setValue("imagemagick.resource.limit." + key, value);
        }
        portletPreferences.store();
        GhostscriptUtil.reset();
        ImageMagickUtil.reset();
    }

    protected void updateLogLevels(ActionRequest actionRequest) throws Exception {
        Enumeration enu = actionRequest.getParameterNames();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            if (!name.startsWith("logLevel")) continue;
            String loggerName = name.substring(8);
            String priority = ParamUtil.getString((PortletRequest)actionRequest, (String)name, (String)Level.INFO.toString());
            Log4JUtil.setLevel((String)loggerName, (String)priority, (boolean)true);
        }
    }

    protected void updateMail(ActionRequest actionRequest, PortletPreferences portletPreferences) throws Exception {
        String advancedProperties = ParamUtil.getString((PortletRequest)actionRequest, (String)"advancedProperties");
        String pop3Host = ParamUtil.getString((PortletRequest)actionRequest, (String)"pop3Host");
        String pop3Password = ParamUtil.getString((PortletRequest)actionRequest, (String)"pop3Password");
        int pop3Port = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"pop3Port");
        boolean pop3Secure = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"pop3Secure");
        String pop3User = ParamUtil.getString((PortletRequest)actionRequest, (String)"pop3User");
        String smtpHost = ParamUtil.getString((PortletRequest)actionRequest, (String)"smtpHost");
        String smtpPassword = ParamUtil.getString((PortletRequest)actionRequest, (String)"smtpPassword");
        int smtpPort = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"smtpPort");
        boolean smtpSecure = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"smtpSecure");
        String smtpUser = ParamUtil.getString((PortletRequest)actionRequest, (String)"smtpUser");
        String storeProtocol = "pop3";
        if (pop3Secure) {
            storeProtocol = "pop3s";
        }
        String transportProtocol = "smtp";
        if (smtpSecure) {
            transportProtocol = "smtps";
        }
        portletPreferences.setValue("mail.session.mail", "true");
        portletPreferences.setValue("mail.session.mail.advanced.properties", advancedProperties);
        portletPreferences.setValue("mail.session.mail.pop3.host", pop3Host);
        if (!pop3Password.equals("TEMP_OBFUSCATION_VALUE")) {
            portletPreferences.setValue("mail.session.mail.pop3.password", pop3Password);
        }
        portletPreferences.setValue("mail.session.mail.pop3.port", String.valueOf(pop3Port));
        portletPreferences.setValue("mail.session.mail.pop3.user", pop3User);
        portletPreferences.setValue("mail.session.mail.smtp.host", smtpHost);
        if (!smtpPassword.equals("TEMP_OBFUSCATION_VALUE")) {
            portletPreferences.setValue("mail.session.mail.smtp.password", smtpPassword);
        }
        portletPreferences.setValue("mail.session.mail.smtp.port", String.valueOf(smtpPort));
        portletPreferences.setValue("mail.session.mail.smtp.user", smtpUser);
        portletPreferences.setValue("mail.session.mail.store.protocol", storeProtocol);
        portletPreferences.setValue("mail.session.mail.transport.protocol", transportProtocol);
        portletPreferences.store();
        this._mailService.clearSession();
    }

    protected void verifyMembershipPolicies() throws Exception {
        OrganizationMembershipPolicy organizationMembershipPolicy = this._organizationMembershipPolicyFactory.getOrganizationMembershipPolicy();
        organizationMembershipPolicy.verifyPolicy();
        RoleMembershipPolicy roleMembershipPolicy = this._roleMembershipPolicyFactory.getRoleMembershipPolicy();
        roleMembershipPolicy.verifyPolicy();
        SiteMembershipPolicy siteMembershipPolicy = this._siteMembershipPolicyFactory.getSiteMembershipPolicy();
        siteMembershipPolicy.verifyPolicy();
        UserGroupMembershipPolicy userGroupMembershipPolicy = this._userGroupMembershipPolicyFactory.getUserGroupMembershipPolicy();
        userGroupMembershipPolicy.verifyPolicy();
    }

    protected void verifyPluginTables() throws Exception {
        this._serviceComponentLocalService.verifyDB();
    }
}

