Liferay.Loader.define('segments-web$lodash@4.17.19/tail', ['module', 'exports', 'require', './_baseSlice'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var baseSlice = require('./_baseSlice');

    /**
     * Gets all but the first element of `array`.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Array
     * @param {Array} array The array to query.
     * @returns {Array} Returns the slice of `array`.
     * @example
     *
     * _.tail([1, 2, 3]);
     * // => [2, 3]
     */
    function tail(array) {
      var length = array == null ? 0 : array.length;
      return length ? baseSlice(array, 1, length) : [];
    }

    module.exports = tail;
  }
});
//# sourceMappingURL=tail.js.map