Liferay.Loader.define('segments-web$lodash@4.17.19/sum', ['module', 'exports', 'require', './_baseSum', './identity'], function (module, exports, require) {
    var define = undefined;
    var global = window;
    {
        var baseSum = require('./_baseSum'),
            identity = require('./identity');

        /**
         * Computes the sum of the values in `array`.
         *
         * @static
         * @memberOf _
         * @since 3.4.0
         * @category Math
         * @param {Array} array The array to iterate over.
         * @returns {number} Returns the sum.
         * @example
         *
         * _.sum([4, 2, 8, 6]);
         * // => 20
         */
        function sum(array) {
            return array && array.length ? baseSum(array, identity) : 0;
        }

        module.exports = sum;
    }
});
//# sourceMappingURL=sum.js.map