Liferay.Loader.define('segments-web$lodash@4.17.19/overSome', ['module', 'exports', 'require', './_arraySome', './_createOver'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var arraySome = require('./_arraySome'),
        createOver = require('./_createOver');

    /**
     * Creates a function that checks if **any** of the `predicates` return
     * truthy when invoked with the arguments it receives.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Util
     * @param {...(Function|Function[])} [predicates=[_.identity]]
     *  The predicates to check.
     * @returns {Function} Returns the new function.
     * @example
     *
     * var func = _.overSome([Boolean, isFinite]);
     *
     * func('1');
     * // => true
     *
     * func(null);
     * // => true
     *
     * func(NaN);
     * // => false
     */
    var overSome = createOver(arraySome);

    module.exports = overSome;
  }
});
//# sourceMappingURL=overSome.js.map