Liferay.Loader.define('segments-web$lodash@4.17.19/_isLaziable', ['module', 'exports', 'require', './_LazyWrapper', './_getData', './_getFuncName', './wrapperLodash'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var LazyWrapper = require('./_LazyWrapper'),
        getData = require('./_getData'),
        getFuncName = require('./_getFuncName'),
        lodash = require('./wrapperLodash');

    /**
     * Checks if `func` has a lazy counterpart.
     *
     * @private
     * @param {Function} func The function to check.
     * @returns {boolean} Returns `true` if `func` has a lazy counterpart,
     *  else `false`.
     */
    function isLaziable(func) {
      var funcName = getFuncName(func),
          other = lodash[funcName];

      if (typeof other != 'function' || !(funcName in LazyWrapper.prototype)) {
        return false;
      }
      if (func === other) {
        return true;
      }
      var data = getData(other);
      return !!data && func === data[0];
    }

    module.exports = isLaziable;
  }
});
//# sourceMappingURL=_isLaziable.js.map