Liferay.Loader.define('segments-web$lodash@4.17.19/_createBind', ['module', 'exports', 'require', './_createCtor', './_root'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var createCtor = require('./_createCtor'),
        root = require('./_root');

    /** Used to compose bitmasks for function metadata. */
    var WRAP_BIND_FLAG = 1;

    /**
     * Creates a function that wraps `func` to invoke it with the optional `this`
     * binding of `thisArg`.
     *
     * @private
     * @param {Function} func The function to wrap.
     * @param {number} bitmask The bitmask flags. See `createWrap` for more details.
     * @param {*} [thisArg] The `this` binding of `func`.
     * @returns {Function} Returns the new wrapped function.
     */
    function createBind(func, bitmask, thisArg) {
      var Ctor = createCtor(func);

      function wrapper() {
        var fn = this && this !== root && this instanceof wrapper ? Ctor : func;
        return fn.apply(bitmask & WRAP_BIND_FLAG ? thisArg : this, arguments);
      }
      return wrapper;
    }

    module.exports = createBind;
  }
});
//# sourceMappingURL=_createBind.js.map