Liferay.Loader.define('segments-web$lodash@4.17.19/_baseIteratee', ['module', 'exports', 'require', './_baseMatches', './_baseMatchesProperty', './identity', './isArray', './property'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var baseMatches = require('./_baseMatches'),
        baseMatchesProperty = require('./_baseMatchesProperty'),
        identity = require('./identity'),
        isArray = require('./isArray'),
        property = require('./property');

    /**
     * The base implementation of `_.iteratee`.
     *
     * @private
     * @param {*} [value=_.identity] The value to convert to an iteratee.
     * @returns {Function} Returns the iteratee.
     */
    function baseIteratee(value) {
      // Don't store the `typeof` result in a variable to avoid a JIT bug in Safari 9.
      // See https://bugs.webkit.org/show_bug.cgi?id=156034 for more details.
      if (typeof value == 'function') {
        return value;
      }
      if (value == null) {
        return identity;
      }
      if (typeof value == 'object') {
        return isArray(value) ? baseMatchesProperty(value[0], value[1]) : baseMatches(value);
      }
      return property(value);
    }

    module.exports = baseIteratee;
  }
});
//# sourceMappingURL=_baseIteratee.js.map