Liferay.Loader.define('segments-web$lodash@4.17.19/_baseGetAllKeys', ['module', 'exports', 'require', './_arrayPush', './isArray'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var arrayPush = require('./_arrayPush'),
        isArray = require('./isArray');

    /**
     * The base implementation of `getAllKeys` and `getAllKeysIn` which uses
     * `keysFunc` and `symbolsFunc` to get the enumerable property names and
     * symbols of `object`.
     *
     * @private
     * @param {Object} object The object to query.
     * @param {Function} keysFunc The function to get the keys of `object`.
     * @param {Function} symbolsFunc The function to get the symbols of `object`.
     * @returns {Array} Returns the array of property names and symbols.
     */
    function baseGetAllKeys(object, keysFunc, symbolsFunc) {
      var result = keysFunc(object);
      return isArray(object) ? result : arrayPush(result, symbolsFunc(object));
    }

    module.exports = baseGetAllKeys;
  }
});
//# sourceMappingURL=_baseGetAllKeys.js.map