Liferay.Loader.define('segments-web$lodash@4.17.19/_baseGet', ['module', 'exports', 'require', './_castPath', './_toKey'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var castPath = require('./_castPath'),
        toKey = require('./_toKey');

    /**
     * The base implementation of `_.get` without support for default values.
     *
     * @private
     * @param {Object} object The object to query.
     * @param {Array|string} path The path of the property to get.
     * @returns {*} Returns the resolved value.
     */
    function baseGet(object, path) {
      path = castPath(path, object);

      var index = 0,
          length = path.length;

      while (object != null && index < length) {
        object = object[toKey(path[index++])];
      }
      return index && index == length ? object : undefined;
    }

    module.exports = baseGet;
  }
});
//# sourceMappingURL=_baseGet.js.map