Liferay.Loader.define('segments-web$lodash@4.17.19/_baseDelay', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    /** Error message constants. */
    var FUNC_ERROR_TEXT = 'Expected a function';

    /**
     * The base implementation of `_.delay` and `_.defer` which accepts `args`
     * to provide to `func`.
     *
     * @private
     * @param {Function} func The function to delay.
     * @param {number} wait The number of milliseconds to delay invocation.
     * @param {Array} args The arguments to provide to `func`.
     * @returns {number|Object} Returns the timer id or timeout object.
     */
    function baseDelay(func, wait, args) {
      if (typeof func != 'function') {
        throw new TypeError(FUNC_ERROR_TEXT);
      }
      return setTimeout(function () {
        func.apply(undefined, args);
      }, wait);
    }

    module.exports = baseDelay;
  }
});
//# sourceMappingURL=_baseDelay.js.map