Liferay.Loader.define('segments-web$lodash@4.17.19/_Hash', ['module', 'exports', 'require', './_hashClear', './_hashDelete', './_hashGet', './_hashHas', './_hashSet'], function (module, exports, require) {
    var define = undefined;
    var global = window;
    {
        var hashClear = require('./_hashClear'),
            hashDelete = require('./_hashDelete'),
            hashGet = require('./_hashGet'),
            hashHas = require('./_hashHas'),
            hashSet = require('./_hashSet');

        /**
         * Creates a hash object.
         *
         * @private
         * @constructor
         * @param {Array} [entries] The key-value pairs to cache.
         */
        function Hash(entries) {
            var index = -1,
                length = entries == null ? 0 : entries.length;

            this.clear();
            while (++index < length) {
                var entry = entries[index];
                this.set(entry[0], entry[1]);
            }
        }

        // Add methods to `Hash`.
        Hash.prototype.clear = hashClear;
        Hash.prototype['delete'] = hashDelete;
        Hash.prototype.get = hashGet;
        Hash.prototype.has = hashHas;
        Hash.prototype.set = hashSet;

        module.exports = Hash;
    }
});
//# sourceMappingURL=_Hash.js.map