Liferay.Loader.define('segments-web$dnd-core@11.1.3/lib/actions/dragDrop/beginDrag', ['module', 'exports', 'require'], function (module, exports, require) {
    var define = undefined;
    var global = window;
    {
        import { invariant } from '@react-dnd/invariant';
        import { setClientOffset } from './local/setClientOffset';
        import { isObject } from '../../utils/js_utils';
        import { BEGIN_DRAG, INIT_COORDS } from './types';
        const ResetCoordinatesAction = {
            type: INIT_COORDS,
            payload: {
                clientOffset: null,
                sourceClientOffset: null
            }
        };
        export function createBeginDrag(manager) {
            return function beginDrag(sourceIds = [], options = {
                publishSource: true
            }) {
                const { publishSource = true, clientOffset, getSourceClientOffset } = options;
                const monitor = manager.getMonitor();
                const registry = manager.getRegistry();
                // Initialize the coordinates using the client offset
                manager.dispatch(setClientOffset(clientOffset));
                verifyInvariants(sourceIds, monitor, registry);
                // Get the draggable source
                const sourceId = getDraggableSource(sourceIds, monitor);
                if (sourceId === null) {
                    manager.dispatch(ResetCoordinatesAction);
                    return;
                }
                // Get the source client offset
                let sourceClientOffset = null;
                if (clientOffset) {
                    if (!getSourceClientOffset) {
                        throw new Error('getSourceClientOffset must be defined');
                    }
                    verifyGetSourceClientOffsetIsFunction(getSourceClientOffset);
                    sourceClientOffset = getSourceClientOffset(sourceId);
                }
                // Initialize the full coordinates
                manager.dispatch(setClientOffset(clientOffset, sourceClientOffset));
                const source = registry.getSource(sourceId);
                const item = source.beginDrag(monitor, sourceId);
                verifyItemIsObject(item);
                registry.pinSource(sourceId);
                const itemType = registry.getSourceType(sourceId);
                return {
                    type: BEGIN_DRAG,
                    payload: {
                        itemType,
                        item,
                        sourceId,
                        clientOffset: clientOffset || null,
                        sourceClientOffset: sourceClientOffset || null,
                        isSourcePublic: !!publishSource
                    }
                };
            };
        }
        function verifyInvariants(sourceIds, monitor, registry) {
            invariant(!monitor.isDragging(), 'Cannot call beginDrag while dragging.');
            sourceIds.forEach(function (sourceId) {
                invariant(registry.getSource(sourceId), 'Expected sourceIds to be registered.');
            });
        }
        function verifyGetSourceClientOffsetIsFunction(getSourceClientOffset) {
            invariant(typeof getSourceClientOffset === 'function', 'When clientOffset is provided, getSourceClientOffset must be a function.');
        }
        function verifyItemIsObject(item) {
            invariant(isObject(item), 'Item must be an object.');
        }
        function getDraggableSource(sourceIds, monitor) {
            let sourceId = null;
            for (let i = sourceIds.length - 1; i >= 0; i--) {
                if (monitor.canDragSource(sourceIds[i])) {
                    sourceId = sourceIds[i];
                    break;
                }
            }
            return sourceId;
        }
    }
});
//# sourceMappingURL=beginDrag.js.map