Liferay.Loader.define('segments-web$date-fns@1.30.1/sub_years/index', ['module', 'exports', 'require', '../add_years/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var addYears = require('../add_years/index');

    /**
     * @category Year Helpers
     * @summary Subtract the specified number of years from the given date.
     *
     * @description
     * Subtract the specified number of years from the given date.
     *
     * @param {Date|String|Number} date - the date to be changed
     * @param {Number} amount - the amount of years to be subtracted
     * @returns {Date} the new date with the years subtracted
     *
     * @example
     * // Subtract 5 years from 1 September 2014:
     * var result = subYears(new Date(2014, 8, 1), 5)
     * //=> Tue Sep 01 2009 00:00:00
     */
    function subYears(dirtyDate, dirtyAmount) {
      var amount = Number(dirtyAmount);
      return addYears(dirtyDate, -amount);
    }

    module.exports = subYears;
  }
});
//# sourceMappingURL=index.js.map