Liferay.Loader.define('segments-web$date-fns@1.30.1/sub_iso_years/index', ['module', 'exports', 'require', '../add_iso_years/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var addISOYears = require('../add_iso_years/index');

    /**
     * @category ISO Week-Numbering Year Helpers
     * @summary Subtract the specified number of ISO week-numbering years from the given date.
     *
     * @description
     * Subtract the specified number of ISO week-numbering years from the given date.
     *
     * ISO week-numbering year: http://en.wikipedia.org/wiki/ISO_week_date
     *
     * @param {Date|String|Number} date - the date to be changed
     * @param {Number} amount - the amount of ISO week-numbering years to be subtracted
     * @returns {Date} the new date with the ISO week-numbering years subtracted
     *
     * @example
     * // Subtract 5 ISO week-numbering years from 1 September 2014:
     * var result = subISOYears(new Date(2014, 8, 1), 5)
     * //=> Mon Aug 31 2009 00:00:00
     */
    function subISOYears(dirtyDate, dirtyAmount) {
      var amount = Number(dirtyAmount);
      return addISOYears(dirtyDate, -amount);
    }

    module.exports = subISOYears;
  }
});
//# sourceMappingURL=index.js.map