Liferay.Loader.define('segments-web$date-fns@1.30.1/start_of_second/index', ['module', 'exports', 'require', '../parse/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var parse = require('../parse/index');

    /**
     * @category Second Helpers
     * @summary Return the start of a second for the given date.
     *
     * @description
     * Return the start of a second for the given date.
     * The result will be in the local timezone.
     *
     * @param {Date|String|Number} date - the original date
     * @returns {Date} the start of a second
     *
     * @example
     * // The start of a second for 1 December 2014 22:15:45.400:
     * var result = startOfSecond(new Date(2014, 11, 1, 22, 15, 45, 400))
     * //=> Mon Dec 01 2014 22:15:45.000
     */
    function startOfSecond(dirtyDate) {
      var date = parse(dirtyDate);
      date.setMilliseconds(0);
      return date;
    }

    module.exports = startOfSecond;
  }
});
//# sourceMappingURL=index.js.map