Liferay.Loader.define('segments-web$date-fns@1.30.1/start_of_quarter/index', ['module', 'exports', 'require', '../parse/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var parse = require('../parse/index');

    /**
     * @category Quarter Helpers
     * @summary Return the start of a year quarter for the given date.
     *
     * @description
     * Return the start of a year quarter for the given date.
     * The result will be in the local timezone.
     *
     * @param {Date|String|Number} date - the original date
     * @returns {Date} the start of a quarter
     *
     * @example
     * // The start of a quarter for 2 September 2014 11:55:00:
     * var result = startOfQuarter(new Date(2014, 8, 2, 11, 55, 0))
     * //=> Tue Jul 01 2014 00:00:00
     */
    function startOfQuarter(dirtyDate) {
      var date = parse(dirtyDate);
      var currentMonth = date.getMonth();

      date.setMonth(currentMonth - currentMonth % 3, 1);
      date.setHours(0, 0, 0, 0);
      return date;
    }

    module.exports = startOfQuarter;
  }
});
//# sourceMappingURL=index.js.map