Liferay.Loader.define('segments-web$date-fns@1.30.1/set_year/index', ['module', 'exports', 'require', '../parse/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var parse = require('../parse/index');

    /**
     * @category Year Helpers
     * @summary Set the year to the given date.
     *
     * @description
     * Set the year to the given date.
     *
     * @param {Date|String|Number} date - the date to be changed
     * @param {Number} year - the year of the new date
     * @returns {Date} the new date with the year setted
     *
     * @example
     * // Set year 2013 to 1 September 2014:
     * var result = setYear(new Date(2014, 8, 1), 2013)
     * //=> Sun Sep 01 2013 00:00:00
     */
    function setYear(dirtyDate, dirtyYear) {
      var date = parse(dirtyDate);
      var year = Number(dirtyYear);
      date.setFullYear(year);
      return date;
    }

    module.exports = setYear;
  }
});
//# sourceMappingURL=index.js.map