Liferay.Loader.define('segments-web$date-fns@1.30.1/set_iso_year/index', ['module', 'exports', 'require', '../parse/index', '../start_of_iso_year/index', '../difference_in_calendar_days/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var parse = require('../parse/index');
    var startOfISOYear = require('../start_of_iso_year/index');
    var differenceInCalendarDays = require('../difference_in_calendar_days/index');

    /**
     * @category ISO Week-Numbering Year Helpers
     * @summary Set the ISO week-numbering year to the given date.
     *
     * @description
     * Set the ISO week-numbering year to the given date,
     * saving the week number and the weekday number.
     *
     * ISO week-numbering year: http://en.wikipedia.org/wiki/ISO_week_date
     *
     * @param {Date|String|Number} date - the date to be changed
     * @param {Number} isoYear - the ISO week-numbering year of the new date
     * @returns {Date} the new date with the ISO week-numbering year setted
     *
     * @example
     * // Set ISO week-numbering year 2007 to 29 December 2008:
     * var result = setISOYear(new Date(2008, 11, 29), 2007)
     * //=> Mon Jan 01 2007 00:00:00
     */
    function setISOYear(dirtyDate, dirtyISOYear) {
      var date = parse(dirtyDate);
      var isoYear = Number(dirtyISOYear);
      var diff = differenceInCalendarDays(date, startOfISOYear(date));
      var fourthOfJanuary = new Date(0);
      fourthOfJanuary.setFullYear(isoYear, 0, 4);
      fourthOfJanuary.setHours(0, 0, 0, 0);
      date = startOfISOYear(fourthOfJanuary);
      date.setDate(date.getDate() + diff);
      return date;
    }

    module.exports = setISOYear;
  }
});
//# sourceMappingURL=index.js.map