Liferay.Loader.define('segments-web$date-fns@1.30.1/set_day/index', ['module', 'exports', 'require', '../parse/index', '../add_days/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var parse = require('../parse/index');
    var addDays = require('../add_days/index');

    /**
     * @category Weekday Helpers
     * @summary Set the day of the week to the given date.
     *
     * @description
     * Set the day of the week to the given date.
     *
     * @param {Date|String|Number} date - the date to be changed
     * @param {Number} day - the day of the week of the new date
     * @param {Object} [options] - the object with options
     * @param {Number} [options.weekStartsOn=0] - the index of the first day of the week (0 - Sunday)
     * @returns {Date} the new date with the day of the week setted
     *
     * @example
     * // Set Sunday to 1 September 2014:
     * var result = setDay(new Date(2014, 8, 1), 0)
     * //=> Sun Aug 31 2014 00:00:00
     *
     * @example
     * // If week starts with Monday, set Sunday to 1 September 2014:
     * var result = setDay(new Date(2014, 8, 1), 0, {weekStartsOn: 1})
     * //=> Sun Sep 07 2014 00:00:00
     */
    function setDay(dirtyDate, dirtyDay, dirtyOptions) {
      var weekStartsOn = dirtyOptions ? Number(dirtyOptions.weekStartsOn) || 0 : 0;
      var date = parse(dirtyDate);
      var day = Number(dirtyDay);
      var currentDay = date.getDay();

      var diff = ((day % 7 + 7) % 7 < weekStartsOn ? 7 : 0) + day - currentDay;
      return addDays(date, diff);
    }

    module.exports = setDay;
  }
});
//# sourceMappingURL=index.js.map