Liferay.Loader.define('segments-web$date-fns@1.30.1/max/index', ['module', 'exports', 'require', '../parse/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var parse = require('../parse/index');

    /**
     * @category Common Helpers
     * @summary Return the latest of the given dates.
     *
     * @description
     * Return the latest of the given dates.
     *
     * @param {...(Date|String|Number)} dates - the dates to compare
     * @returns {Date} the latest of the dates
     *
     * @example
     * // Which of these dates is the latest?
     * var result = max(
     *   new Date(1989, 6, 10),
     *   new Date(1987, 1, 11),
     *   new Date(1995, 6, 2),
     *   new Date(1990, 0, 1)
     * )
     * //=> Sun Jul 02 1995 00:00:00
     */
    function max() {
      var dirtyDates = Array.prototype.slice.call(arguments);
      var dates = dirtyDates.map(function (dirtyDate) {
        return parse(dirtyDate);
      });
      var latestTimestamp = Math.max.apply(null, dates);
      return new Date(latestTimestamp);
    }

    module.exports = max;
  }
});
//# sourceMappingURL=index.js.map