Liferay.Loader.define('segments-web$date-fns@1.30.1/locale/ca/build_format_locale/index', ['module', 'exports', 'require', '../../_lib/build_formatting_tokens_reg_exp/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var buildFormattingTokensRegExp = require('../../_lib/build_formatting_tokens_reg_exp/index');

    function buildFormatLocale() {
      var months3char = ['gen', 'feb', 'mar', 'abr', 'mai', 'jun', 'jul', 'ago', 'set', 'oct', 'nov', 'des'];
      var monthsFull = ['gener', 'febrer', 'març', 'abril', 'maig', 'juny', 'juliol', 'agost', 'setembre', 'octobre', 'novembre', 'desembre'];
      var weekdays2char = ['dg', 'dl', 'dt', 'dc', 'dj', 'dv', 'ds'];
      var weekdays3char = ['dge', 'dls', 'dts', 'dcs', 'djs', 'dvs', 'dss'];
      var weekdaysFull = ['diumenge', 'dilluns', 'dimarts', 'dimecres', 'dijous', 'divendres', 'dissabte'];
      var meridiemUppercase = ['AM', 'PM'];
      var meridiemLowercase = ['am', 'pm'];
      var meridiemFull = ['a.m.', 'p.m.'];

      var formatters = {
        // Month: Jan, Feb, ..., Dec
        'MMM': function (date) {
          return months3char[date.getMonth()];
        },

        // Month: January, February, ..., December
        'MMMM': function (date) {
          return monthsFull[date.getMonth()];
        },

        // Day of week: Su, Mo, ..., Sa
        'dd': function (date) {
          return weekdays2char[date.getDay()];
        },

        // Day of week: Sun, Mon, ..., Sat
        'ddd': function (date) {
          return weekdays3char[date.getDay()];
        },

        // Day of week: Sunday, Monday, ..., Saturday
        'dddd': function (date) {
          return weekdaysFull[date.getDay()];
        },

        // AM, PM
        'A': function (date) {
          return date.getHours() / 12 >= 1 ? meridiemUppercase[1] : meridiemUppercase[0];
        },

        // am, pm
        'a': function (date) {
          return date.getHours() / 12 >= 1 ? meridiemLowercase[1] : meridiemLowercase[0];
        },

        // a.m., p.m.
        'aa': function (date) {
          return date.getHours() / 12 >= 1 ? meridiemFull[1] : meridiemFull[0];
        }

        // Generate ordinal version of formatters: M -> Mo, D -> Do, etc.
      };
      ['M', 'D', 'DDD', 'd', 'Q', 'W'].forEach(function (formatterToken) {
        formatters[formatterToken + 'o'] = function (date, formatters) {
          return ordinal(formatters[formatterToken](date));
        };
      });

      return {
        formatters: formatters,
        formattingTokensRegExp: buildFormattingTokensRegExp(formatters)
      };
    }

    function ordinal(number) {
      switch (number) {
        case 1:
          return '1r';
        case 2:
          return '2n';
        case 3:
          return '3r';
        case 4:
          return '4t';
        default:
          return number + 'è';
      }
    }

    module.exports = buildFormatLocale;
  }
});
//# sourceMappingURL=index.js.map