Liferay.Loader.define('segments-web$date-fns@1.30.1/is_within_range/index', ['module', 'exports', 'require', '../parse/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var parse = require('../parse/index');

    /**
     * @category Range Helpers
     * @summary Is the given date within the range?
     *
     * @description
     * Is the given date within the range?
     *
     * @param {Date|String|Number} date - the date to check
     * @param {Date|String|Number} startDate - the start of range
     * @param {Date|String|Number} endDate - the end of range
     * @returns {Boolean} the date is within the range
     * @throws {Error} startDate cannot be after endDate
     *
     * @example
     * // For the date within the range:
     * isWithinRange(
     *   new Date(2014, 0, 3), new Date(2014, 0, 1), new Date(2014, 0, 7)
     * )
     * //=> true
     *
     * @example
     * // For the date outside of the range:
     * isWithinRange(
     *   new Date(2014, 0, 10), new Date(2014, 0, 1), new Date(2014, 0, 7)
     * )
     * //=> false
     */
    function isWithinRange(dirtyDate, dirtyStartDate, dirtyEndDate) {
      var time = parse(dirtyDate).getTime();
      var startTime = parse(dirtyStartDate).getTime();
      var endTime = parse(dirtyEndDate).getTime();

      if (startTime > endTime) {
        throw new Error('The start of the range cannot be after the end of the range');
      }

      return time >= startTime && time <= endTime;
    }

    module.exports = isWithinRange;
  }
});
//# sourceMappingURL=index.js.map