Liferay.Loader.define('segments-web$date-fns@1.30.1/is_this_second/index', ['module', 'exports', 'require', '../is_same_second/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var isSameSecond = require('../is_same_second/index');

    /**
     * @category Second Helpers
     * @summary Is the given date in the same second as the current date?
     *
     * @description
     * Is the given date in the same second as the current date?
     *
     * @param {Date|String|Number} date - the date to check
     * @returns {Boolean} the date is in this second
     *
     * @example
     * // If now is 25 September 2014 18:30:15.500,
     * // is 25 September 2014 18:30:15.000 in this second?
     * var result = isThisSecond(new Date(2014, 8, 25, 18, 30, 15))
     * //=> true
     */
    function isThisSecond(dirtyDate) {
      return isSameSecond(new Date(), dirtyDate);
    }

    module.exports = isThisSecond;
  }
});
//# sourceMappingURL=index.js.map