Liferay.Loader.define('segments-web$date-fns@1.30.1/is_this_minute/index', ['module', 'exports', 'require', '../is_same_minute/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var isSameMinute = require('../is_same_minute/index');

    /**
     * @category Minute Helpers
     * @summary Is the given date in the same minute as the current date?
     *
     * @description
     * Is the given date in the same minute as the current date?
     *
     * @param {Date|String|Number} date - the date to check
     * @returns {Boolean} the date is in this minute
     *
     * @example
     * // If now is 25 September 2014 18:30:15.500,
     * // is 25 September 2014 18:30:00 in this minute?
     * var result = isThisMinute(new Date(2014, 8, 25, 18, 30))
     * //=> true
     */
    function isThisMinute(dirtyDate) {
      return isSameMinute(new Date(), dirtyDate);
    }

    module.exports = isThisMinute;
  }
});
//# sourceMappingURL=index.js.map