Liferay.Loader.define('segments-web$date-fns@1.30.1/is_same_week/index', ['module', 'exports', 'require', '../start_of_week/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var startOfWeek = require('../start_of_week/index');

    /**
     * @category Week Helpers
     * @summary Are the given dates in the same week?
     *
     * @description
     * Are the given dates in the same week?
     *
     * @param {Date|String|Number} dateLeft - the first date to check
     * @param {Date|String|Number} dateRight - the second date to check
     * @param {Object} [options] - the object with options
     * @param {Number} [options.weekStartsOn=0] - the index of the first day of the week (0 - Sunday)
     * @returns {Boolean} the dates are in the same week
     *
     * @example
     * // Are 31 August 2014 and 4 September 2014 in the same week?
     * var result = isSameWeek(
     *   new Date(2014, 7, 31),
     *   new Date(2014, 8, 4)
     * )
     * //=> true
     *
     * @example
     * // If week starts with Monday,
     * // are 31 August 2014 and 4 September 2014 in the same week?
     * var result = isSameWeek(
     *   new Date(2014, 7, 31),
     *   new Date(2014, 8, 4),
     *   {weekStartsOn: 1}
     * )
     * //=> false
     */
    function isSameWeek(dirtyDateLeft, dirtyDateRight, dirtyOptions) {
      var dateLeftStartOfWeek = startOfWeek(dirtyDateLeft, dirtyOptions);
      var dateRightStartOfWeek = startOfWeek(dirtyDateRight, dirtyOptions);

      return dateLeftStartOfWeek.getTime() === dateRightStartOfWeek.getTime();
    }

    module.exports = isSameWeek;
  }
});
//# sourceMappingURL=index.js.map