Liferay.Loader.define('segments-web$date-fns@1.30.1/is_same_month/index', ['module', 'exports', 'require', '../parse/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var parse = require('../parse/index');

    /**
     * @category Month Helpers
     * @summary Are the given dates in the same month?
     *
     * @description
     * Are the given dates in the same month?
     *
     * @param {Date|String|Number} dateLeft - the first date to check
     * @param {Date|String|Number} dateRight - the second date to check
     * @returns {Boolean} the dates are in the same month
     *
     * @example
     * // Are 2 September 2014 and 25 September 2014 in the same month?
     * var result = isSameMonth(
     *   new Date(2014, 8, 2),
     *   new Date(2014, 8, 25)
     * )
     * //=> true
     */
    function isSameMonth(dirtyDateLeft, dirtyDateRight) {
      var dateLeft = parse(dirtyDateLeft);
      var dateRight = parse(dirtyDateRight);
      return dateLeft.getFullYear() === dateRight.getFullYear() && dateLeft.getMonth() === dateRight.getMonth();
    }

    module.exports = isSameMonth;
  }
});
//# sourceMappingURL=index.js.map