Liferay.Loader.define('segments-web$date-fns@1.30.1/is_same_minute/index', ['module', 'exports', 'require', '../start_of_minute/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var startOfMinute = require('../start_of_minute/index');

    /**
     * @category Minute Helpers
     * @summary Are the given dates in the same minute?
     *
     * @description
     * Are the given dates in the same minute?
     *
     * @param {Date|String|Number} dateLeft - the first date to check
     * @param {Date|String|Number} dateRight - the second date to check
     * @returns {Boolean} the dates are in the same minute
     *
     * @example
     * // Are 4 September 2014 06:30:00 and 4 September 2014 06:30:15
     * // in the same minute?
     * var result = isSameMinute(
     *   new Date(2014, 8, 4, 6, 30),
     *   new Date(2014, 8, 4, 6, 30, 15)
     * )
     * //=> true
     */
    function isSameMinute(dirtyDateLeft, dirtyDateRight) {
      var dateLeftStartOfMinute = startOfMinute(dirtyDateLeft);
      var dateRightStartOfMinute = startOfMinute(dirtyDateRight);

      return dateLeftStartOfMinute.getTime() === dateRightStartOfMinute.getTime();
    }

    module.exports = isSameMinute;
  }
});
//# sourceMappingURL=index.js.map