Liferay.Loader.define('segments-web$date-fns@1.30.1/is_future/index', ['module', 'exports', 'require', '../parse/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var parse = require('../parse/index');

    /**
     * @category Common Helpers
     * @summary Is the given date in the future?
     *
     * @description
     * Is the given date in the future?
     *
     * @param {Date|String|Number} date - the date to check
     * @returns {Boolean} the date is in the future
     *
     * @example
     * // If today is 6 October 2014, is 31 December 2014 in the future?
     * var result = isFuture(new Date(2014, 11, 31))
     * //=> true
     */
    function isFuture(dirtyDate) {
      return parse(dirtyDate).getTime() > new Date().getTime();
    }

    module.exports = isFuture;
  }
});
//# sourceMappingURL=index.js.map