Liferay.Loader.define('segments-web$date-fns@1.30.1/is_first_day_of_month/index', ['module', 'exports', 'require', '../parse/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var parse = require('../parse/index');

    /**
     * @category Month Helpers
     * @summary Is the given date the first day of a month?
     *
     * @description
     * Is the given date the first day of a month?
     *
     * @param {Date|String|Number} date - the date to check
     * @returns {Boolean} the date is the first day of a month
     *
     * @example
     * // Is 1 September 2014 the first day of a month?
     * var result = isFirstDayOfMonth(new Date(2014, 8, 1))
     * //=> true
     */
    function isFirstDayOfMonth(dirtyDate) {
      return parse(dirtyDate).getDate() === 1;
    }

    module.exports = isFirstDayOfMonth;
  }
});
//# sourceMappingURL=index.js.map