Liferay.Loader.define('segments-web$date-fns@1.30.1/is_after/index', ['module', 'exports', 'require', '../parse/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var parse = require('../parse/index');

    /**
     * @category Common Helpers
     * @summary Is the first date after the second one?
     *
     * @description
     * Is the first date after the second one?
     *
     * @param {Date|String|Number} date - the date that should be after the other one to return true
     * @param {Date|String|Number} dateToCompare - the date to compare with
     * @returns {Boolean} the first date is after the second date
     *
     * @example
     * // Is 10 July 1989 after 11 February 1987?
     * var result = isAfter(new Date(1989, 6, 10), new Date(1987, 1, 11))
     * //=> true
     */
    function isAfter(dirtyDate, dirtyDateToCompare) {
      var date = parse(dirtyDate);
      var dateToCompare = parse(dirtyDateToCompare);
      return date.getTime() > dateToCompare.getTime();
    }

    module.exports = isAfter;
  }
});
//# sourceMappingURL=index.js.map