Liferay.Loader.define('segments-web$date-fns@1.30.1/get_days_in_year/index', ['module', 'exports', 'require', '../is_leap_year/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var isLeapYear = require('../is_leap_year/index');

    /**
     * @category Year Helpers
     * @summary Get the number of days in a year of the given date.
     *
     * @description
     * Get the number of days in a year of the given date.
     *
     * @param {Date|String|Number} date - the given date
     * @returns {Number} the number of days in a year
     *
     * @example
     * // How many days are in 2012?
     * var result = getDaysInYear(new Date(2012, 0, 1))
     * //=> 366
     */
    function getDaysInYear(dirtyDate) {
      return isLeapYear(dirtyDate) ? 366 : 365;
    }

    module.exports = getDaysInYear;
  }
});
//# sourceMappingURL=index.js.map