Liferay.Loader.define("segments-web$date-fns@1.30.1/end_of_yesterday/index", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    /**
     * @category Day Helpers
     * @summary Return the end of yesterday.
     *
     * @description
     * Return the end of yesterday.
     *
     * @returns {Date} the end of yesterday
     *
     * @example
     * // If today is 6 October 2014:
     * var result = endOfYesterday()
     * //=> Sun Oct 5 2014 23:59:59.999
     */
    function endOfYesterday() {
      var now = new Date();
      var year = now.getFullYear();
      var month = now.getMonth();
      var day = now.getDate();

      var date = new Date(0);
      date.setFullYear(year, month, day - 1);
      date.setHours(23, 59, 59, 999);
      return date;
    }

    module.exports = endOfYesterday;
  }
});
//# sourceMappingURL=index.js.map