Liferay.Loader.define('segments-web$date-fns@1.30.1/end_of_year/index', ['module', 'exports', 'require', '../parse/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var parse = require('../parse/index');

    /**
     * @category Year Helpers
     * @summary Return the end of a year for the given date.
     *
     * @description
     * Return the end of a year for the given date.
     * The result will be in the local timezone.
     *
     * @param {Date|String|Number} date - the original date
     * @returns {Date} the end of a year
     *
     * @example
     * // The end of a year for 2 September 2014 11:55:00:
     * var result = endOfYear(new Date(2014, 8, 2, 11, 55, 00))
     * //=> Wed Dec 31 2014 23:59:59.999
     */
    function endOfYear(dirtyDate) {
      var date = parse(dirtyDate);
      var year = date.getFullYear();
      date.setFullYear(year + 1, 0, 0);
      date.setHours(23, 59, 59, 999);
      return date;
    }

    module.exports = endOfYear;
  }
});
//# sourceMappingURL=index.js.map