Liferay.Loader.define('segments-web$date-fns@1.30.1/end_of_minute/index', ['module', 'exports', 'require', '../parse/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var parse = require('../parse/index');

    /**
     * @category Minute Helpers
     * @summary Return the end of a minute for the given date.
     *
     * @description
     * Return the end of a minute for the given date.
     * The result will be in the local timezone.
     *
     * @param {Date|String|Number} date - the original date
     * @returns {Date} the end of a minute
     *
     * @example
     * // The end of a minute for 1 December 2014 22:15:45.400:
     * var result = endOfMinute(new Date(2014, 11, 1, 22, 15, 45, 400))
     * //=> Mon Dec 01 2014 22:15:59.999
     */
    function endOfMinute(dirtyDate) {
      var date = parse(dirtyDate);
      date.setSeconds(59, 999);
      return date;
    }

    module.exports = endOfMinute;
  }
});
//# sourceMappingURL=index.js.map