Liferay.Loader.define('segments-web$date-fns@1.30.1/difference_in_seconds/index', ['module', 'exports', 'require', '../difference_in_milliseconds/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var differenceInMilliseconds = require('../difference_in_milliseconds/index');

    /**
     * @category Second Helpers
     * @summary Get the number of seconds between the given dates.
     *
     * @description
     * Get the number of seconds between the given dates.
     *
     * @param {Date|String|Number} dateLeft - the later date
     * @param {Date|String|Number} dateRight - the earlier date
     * @returns {Number} the number of seconds
     *
     * @example
     * // How many seconds are between
     * // 2 July 2014 12:30:07.999 and 2 July 2014 12:30:20.000?
     * var result = differenceInSeconds(
     *   new Date(2014, 6, 2, 12, 30, 20, 0),
     *   new Date(2014, 6, 2, 12, 30, 7, 999)
     * )
     * //=> 12
     */
    function differenceInSeconds(dirtyDateLeft, dirtyDateRight) {
      var diff = differenceInMilliseconds(dirtyDateLeft, dirtyDateRight) / 1000;
      return diff > 0 ? Math.floor(diff) : Math.ceil(diff);
    }

    module.exports = differenceInSeconds;
  }
});
//# sourceMappingURL=index.js.map