Liferay.Loader.define('segments-web$date-fns@1.30.1/difference_in_calendar_iso_weeks/index', ['module', 'exports', 'require', '../start_of_iso_week/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var startOfISOWeek = require('../start_of_iso_week/index');

    var MILLISECONDS_IN_MINUTE = 60000;
    var MILLISECONDS_IN_WEEK = 604800000;

    /**
     * @category ISO Week Helpers
     * @summary Get the number of calendar ISO weeks between the given dates.
     *
     * @description
     * Get the number of calendar ISO weeks between the given dates.
     *
     * ISO week-numbering year: http://en.wikipedia.org/wiki/ISO_week_date
     *
     * @param {Date|String|Number} dateLeft - the later date
     * @param {Date|String|Number} dateRight - the earlier date
     * @returns {Number} the number of calendar ISO weeks
     *
     * @example
     * // How many calendar ISO weeks are between 6 July 2014 and 21 July 2014?
     * var result = differenceInCalendarISOWeeks(
     *   new Date(2014, 6, 21),
     *   new Date(2014, 6, 6)
     * )
     * //=> 3
     */
    function differenceInCalendarISOWeeks(dirtyDateLeft, dirtyDateRight) {
      var startOfISOWeekLeft = startOfISOWeek(dirtyDateLeft);
      var startOfISOWeekRight = startOfISOWeek(dirtyDateRight);

      var timestampLeft = startOfISOWeekLeft.getTime() - startOfISOWeekLeft.getTimezoneOffset() * MILLISECONDS_IN_MINUTE;
      var timestampRight = startOfISOWeekRight.getTime() - startOfISOWeekRight.getTimezoneOffset() * MILLISECONDS_IN_MINUTE;

      // Round the number of days to the nearest integer
      // because the number of milliseconds in a week is not constant
      // (e.g. it's different in the week of the daylight saving time clock shift)
      return Math.round((timestampLeft - timestampRight) / MILLISECONDS_IN_WEEK);
    }

    module.exports = differenceInCalendarISOWeeks;
  }
});
//# sourceMappingURL=index.js.map