Liferay.Loader.define("segments-web@2.0.22/js/components/criteria_builder/CriteriaBuilder.es", ['module', 'exports', 'require', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../../utils/types.es', '../../utils/utils.es', './CriteriaGroup.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = void 0;

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _types = require("../../utils/types.es");

    var _utils = require("../../utils/utils.es");

    var _CriteriaGroup = _interopRequireDefault(require("./CriteriaGroup.es"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj["default"] = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _classCallCheck(instance, Constructor) {
      if (!(instance instanceof Constructor)) {
        throw new TypeError("Cannot call a class as a function");
      }
    }

    function _defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
      }
    }

    function _createClass(Constructor, protoProps, staticProps) {
      if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
    }

    function _possibleConstructorReturn(self, call) {
      if (call && (_typeof(call) === "object" || typeof call === "function")) {
        return call;
      }return _assertThisInitialized(self);
    }

    function _getPrototypeOf(o) {
      _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
        return o.__proto__ || Object.getPrototypeOf(o);
      };return _getPrototypeOf(o);
    }

    function _assertThisInitialized(self) {
      if (self === void 0) {
        throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
      }return self;
    }

    function _inherits(subClass, superClass) {
      if (typeof superClass !== "function" && superClass !== null) {
        throw new TypeError("Super expression must either be null or a function");
      }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
    }

    function _setPrototypeOf(o, p) {
      _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
        o.__proto__ = p;return o;
      };return _setPrototypeOf(o, p);
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    var CriteriaBuilder = /*#__PURE__*/function (_Component) {
      _inherits(CriteriaBuilder, _Component);

      function CriteriaBuilder() {
        var _getPrototypeOf2;

        var _this;

        _classCallCheck(this, CriteriaBuilder);

        for (var _len = arguments.length, _args = new Array(_len), _key = 0; _key < _len; _key++) {
          _args[_key] = arguments[_key];
        }

        _this = _possibleConstructorReturn(this, (_getPrototypeOf2 = _getPrototypeOf(CriteriaBuilder)).call.apply(_getPrototypeOf2, [this].concat(_args)));

        _defineProperty(_assertThisInitialized(_this), "_handleCriteriaChange", function (newCriteria) {
          var items = _this._cleanCriteriaMapItems([newCriteria], true);

          _this.props.onChange(items[items.length - 1], _this.props.propertyKey);
        });

        _defineProperty(_assertThisInitialized(_this), "_handleCriterionMove", function () {
          var _this2;

          for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
            args[_key2] = arguments[_key2];
          }

          var newCriteria = (_this2 = _this)._searchAndUpdateCriteria.apply(_this2, [_this.props.criteria].concat(args));

          _this._handleCriteriaChange(newCriteria);
        });

        _defineProperty(_assertThisInitialized(_this), "_searchAndUpdateCriteria", function (criteria, startGroupId, startIndex, destGroupId, destIndex, addCriterion, replace) {
          var updatedCriteriaItems = criteria.items;

          if (criteria.groupId === destGroupId) {
            updatedCriteriaItems = replace ? (0, _utils.replaceAtIndex)(addCriterion, updatedCriteriaItems, destIndex) : (0, _utils.insertAtIndex)(addCriterion, updatedCriteriaItems, destIndex);
          }

          if (criteria.groupId === startGroupId) {
            updatedCriteriaItems = (0, _utils.removeAtIndex)(updatedCriteriaItems, destGroupId === startGroupId && destIndex < startIndex && !replace ? startIndex + 1 : startIndex);
          }

          return _objectSpread({}, criteria, {
            items: updatedCriteriaItems.map(function (item) {
              return _this._isGroupItem(item) ? _this._searchAndUpdateCriteria(item, startGroupId, startIndex, destGroupId, destIndex, addCriterion, replace) : item;
            })
          });
        });

        return _this;
      }

      _createClass(CriteriaBuilder, [{
        key: "_cleanCriteriaMapItems",

        /**
         * Cleans criteria items by performing the following:
         * 1. Remove any groups with no items.
         * 2. Flatten groups that directly contain a single group.
         * 3. Flatten groups that contain a single criterion.
         * @param {Array} criteriaItems A list of criterion and criteria groups
         * @param {boolean} root True if the criteriaItems are from the root group.
         * to clean.
         * @returns {*}
         */
        value: function _cleanCriteriaMapItems(criteriaItems, root) {
          var _this3 = this;

          var criteria = criteriaItems.filter(function (_ref) {
            var items = _ref.items;
            return items ? items.length : true;
          }).map(function (item) {
            var cleanedItem = item;

            if (item.items) {
              if (item.items.length === 1) {
                var soloItem = item.items[0];

                if (soloItem.items) {
                  cleanedItem = {
                    conjunctionName: soloItem.conjunctionName,
                    groupId: soloItem.groupId,
                    items: _this3._cleanCriteriaMapItems(soloItem.items)
                  };
                } else {
                  cleanedItem = root ? item : soloItem;
                }
              } else {
                cleanedItem = _objectSpread({}, item, {
                  items: _this3._cleanCriteriaMapItems(item.items)
                });
              }
            }

            return cleanedItem;
          });
          return criteria;
        }
        /**
         * Cleans and updates the criteria with the newer criteria.
         * @param {Object} newCriteria The criteria with the most recent changes.
         */

      }, {
        key: "_isGroupItem",

        /**
         * Checks if an item is a group item by checking if it contains an items
         * property with at least 1 item.
         * @param {object} item The criteria item to check.
         * @returns True if the item is a group.
         */
        value: function _isGroupItem(item) {
          return item.items && item.items.length;
        }
        /**
         * Searches through the criteria object and adds or replaces and removes
         * the criterion at their respective specified index. insertAtIndex must
         * come before removeAtIndex since the startIndex is incremented by 1
         * when the destination index comes before the start index in the same
         * group. The startIndex is not incremented if a replace is occurring.
         * This is used for moving a criterion between groups.
         * @param {object} criteria The criteria object to update.
         * @param {string} startGroupId Group ID of the item to remove.
         * @param {number} startIndex Index in the group to remove.
         * @param {string} destGroupId Group ID of the item to add.
         * @param {number} destIndex Index in the group where the criterion will
         * be added.
         * @param {object} addCriterion The criterion that is being moved.
         * @param {boolean} replace True if the destIndex should replace rather than
         * insert.
         */

      }, {
        key: "render",
        value: function render() {
          var _this$props = this.props,
              criteria = _this$props.criteria,
              editing = _this$props.editing,
              emptyContributors = _this$props.emptyContributors,
              entityName = _this$props.entityName,
              modelLabel = _this$props.modelLabel,
              propertyKey = _this$props.propertyKey,
              supportedConjunctions = _this$props.supportedConjunctions,
              supportedOperators = _this$props.supportedOperators,
              supportedProperties = _this$props.supportedProperties,
              supportedPropertyTypes = _this$props.supportedPropertyTypes;
          return _react["default"].createElement("div", {
            className: "criteria-builder-root"
          }, _react["default"].createElement("h4", {
            className: "sheet-subtitle"
          }, (0, _utils.sub)(Liferay.Language.get('x-with-property-x'), [modelLabel, ''], false)), (!emptyContributors || editing) && _react["default"].createElement(_CriteriaGroup["default"], {
            criteria: criteria,
            editing: editing,
            emptyContributors: emptyContributors,
            entityName: entityName,
            groupId: criteria && criteria.groupId,
            modelLabel: modelLabel,
            onChange: this._handleCriteriaChange,
            onMove: this._handleCriterionMove,
            propertyKey: propertyKey,
            root: true,
            supportedConjunctions: supportedConjunctions,
            supportedOperators: supportedOperators,
            supportedProperties: supportedProperties,
            supportedPropertyTypes: supportedPropertyTypes
          }));
        }
      }]);

      return CriteriaBuilder;
    }(_react.Component);

    var _default = CriteriaBuilder;
    exports["default"] = _default;
    //# sourceMappingURL=CriteriaBuilder.es.js.map
  }
});
//# sourceMappingURL=CriteriaBuilder.es.js.map