/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.criteria;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class Criteria
implements Serializable {
    private final Map<String, Criterion> _criteria = new HashMap<String, Criterion>();
    private final Map<String, String> _filterStrings = new HashMap<String, String>();

    public void addCriterion(String key, Type type, String filterString, Conjunction conjunction) {
        if (Validator.isNull((String)filterString)) {
            return;
        }
        Criterion criterion = this.getCriterion(key);
        if (criterion == null) {
            this._criteria.put(key, new Criterion(type, filterString, conjunction));
            return;
        }
        criterion = new Criterion(type, this._combineFilters(criterion.getFilterString(), filterString, conjunction), Conjunction.parse(criterion.getConjunction()));
        this._criteria.put(key, criterion);
    }

    public void addFilter(Type type, String filterString, Conjunction conjunction) {
        if (Validator.isNull((String)filterString)) {
            return;
        }
        String typeValueFilterString = this._filterStrings.get(type.getValue());
        if (Validator.isNull((String)typeValueFilterString)) {
            this._filterStrings.put(type.getValue(), filterString);
            return;
        }
        this._filterStrings.put(type.getValue(), this._combineFilters(typeValueFilterString, filterString, conjunction));
    }

    public Map<String, Criterion> getCriteria() {
        return this._criteria;
    }

    public Criterion getCriterion(String key) {
        return this._criteria.get(key);
    }

    public String getFilterString(Type type) {
        return this._filterStrings.get(type.getValue());
    }

    public Map<String, String> getFilterStrings() {
        return this._filterStrings;
    }

    public Conjunction getTypeConjunction(Type type) {
        for (Criterion criterion : this._criteria.values()) {
            if (!Objects.equals(type.getValue(), criterion.getTypeValue())) continue;
            return Conjunction.parse(criterion.getConjunction());
        }
        return Conjunction.AND;
    }

    private String _combineFilters(String filterString1, String filterString2, Conjunction conjunction) {
        return StringBundler.concat((String[])new String[]{"(", filterString1, ")", " ", conjunction.getValue(), " ", "(", filterString2, ")"});
    }

    public static enum Type {
        CONTEXT("context"),
        MODEL("model"),
        REFERRED("referred");

        private final String _value;

        public static Type parse(String value) {
            if (Objects.equals(CONTEXT.getValue(), value)) {
                return CONTEXT;
            }
            if (Objects.equals(MODEL.getValue(), value)) {
                return MODEL;
            }
            if (Objects.equals(REFERRED.getValue(), value)) {
                return REFERRED;
            }
            throw new IllegalArgumentException("Invalid value " + value);
        }

        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private Type(String value) {
            this._value = value;
        }
    }

    public static enum Conjunction {
        AND("and"),
        OR("or");

        private final String _value;

        public static Conjunction parse(String value) {
            if (Objects.equals(AND.getValue(), value)) {
                return AND;
            }
            if (Objects.equals(OR.getValue(), value)) {
                return OR;
            }
            throw new IllegalArgumentException("Invalid value " + value);
        }

        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private Conjunction(String value) {
            this._value = value;
        }
    }

    public static final class Criterion
    implements Serializable {
        private String _conjunction;
        private String _filterString;
        private String _typeValue;

        public Criterion() {
        }

        public Criterion(Type type, String filterString, Conjunction conjunction) {
            this._filterString = filterString;
            this._conjunction = conjunction.getValue();
            this._typeValue = type.getValue();
        }

        public String getConjunction() {
            return this._conjunction;
        }

        public String getFilterString() {
            return this._filterString;
        }

        public String getTypeValue() {
            return this._typeValue;
        }
    }
}

