/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.rss.web.internal.util;

import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.webcache.WebCacheItem;
import com.liferay.portal.kernel.webcache.WebCachePoolUtil;
import com.liferay.rss.web.internal.configuration.RSSWebCacheConfiguration;
import com.liferay.rss.web.internal.util.RSSFeedEntry;
import com.liferay.rss.web.internal.util.RSSWebCacheItem;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndImage;
import java.util.ArrayList;
import java.util.List;

public class RSSFeed {
    private final String _baseURL;
    private List<RSSFeedEntry> _rssFeedEntries;
    private final RSSWebCacheConfiguration _rssWebCacheConfiguration;
    private SyndFeed _syndFeed;
    private final String _syndFeedImageLink;
    private final String _syndFeedImageURL;
    private final String _syndFeedLink;
    private final String _title;
    private final String _url;

    public RSSFeed(RSSWebCacheConfiguration rssWebCacheConfiguration, String url, String title) {
        this._rssWebCacheConfiguration = rssWebCacheConfiguration;
        this._url = url;
        SyndFeed syndFeed = this.getSyndFeed();
        if (syndFeed == null) {
            this._baseURL = "";
            this._syndFeedImageLink = "";
            this._syndFeedImageURL = "";
            this._syndFeedLink = "";
            this._title = title;
            return;
        }
        if (Validator.isNull((String)title)) {
            title = syndFeed.getTitle();
        }
        String baseURL = "";
        String syndFeedImageLink = "";
        String syndFeedImageURL = "";
        String syndFeedLink = syndFeed.getLink();
        if (Validator.isNull((String)syndFeedLink) || !HttpUtil.hasDomain((String)syndFeedLink)) {
            baseURL = HttpUtil.getProtocol((String)this._url).concat("://").concat(HttpUtil.getDomain((String)this._url));
            syndFeedLink = Validator.isNotNull((String)syndFeedLink) ? baseURL.concat(syndFeedLink) : baseURL;
        } else {
            baseURL = HttpUtil.getProtocol((String)syndFeedLink).concat("://").concat(HttpUtil.getDomain((String)syndFeedLink));
        }
        SyndImage syndImage = syndFeed.getImage();
        if (syndImage != null) {
            syndFeedImageLink = syndImage.getLink();
            if (!HttpUtil.hasDomain((String)syndFeedImageLink)) {
                syndFeedImageLink = baseURL + syndFeedImageLink;
            }
            if (!HttpUtil.hasDomain((String)(syndFeedImageURL = syndImage.getUrl()))) {
                syndFeedImageURL = baseURL + syndFeedImageURL;
            }
        }
        this._baseURL = baseURL;
        this._syndFeedImageLink = syndFeedImageLink;
        this._syndFeedImageURL = syndFeedImageURL;
        this._syndFeedLink = syndFeedLink;
        this._title = title;
    }

    public String getBaseURL() {
        return this._baseURL;
    }

    public List<RSSFeedEntry> getRSSFeedEntries(ThemeDisplay themeDisplay) {
        if (this._rssFeedEntries != null) {
            return this._rssFeedEntries;
        }
        this._rssFeedEntries = new ArrayList<RSSFeedEntry>();
        SyndFeed syndFeed = this.getSyndFeed();
        if (syndFeed == null) {
            return this._rssFeedEntries;
        }
        for (Object syndEntry : syndFeed.getEntries()) {
            RSSFeedEntry rssFeedEntry = new RSSFeedEntry(this, (SyndEntry)syndEntry, themeDisplay);
            this._rssFeedEntries.add(rssFeedEntry);
        }
        return this._rssFeedEntries;
    }

    public SyndFeed getSyndFeed() {
        if (this._syndFeed != null) {
            return this._syndFeed;
        }
        RSSWebCacheItem wci = new RSSWebCacheItem(this._rssWebCacheConfiguration, this._url);
        this._syndFeed = (SyndFeed)WebCachePoolUtil.get((String)(RSSFeed.class.getName() + "." + this._url), (WebCacheItem)wci);
        return this._syndFeed;
    }

    public String getSyndFeedImageLink() {
        return this._syndFeedImageLink;
    }

    public String getSyndFeedImageURL() {
        return this._syndFeedImageURL;
    }

    public String getSyndFeedLink() {
        return this._syndFeedLink;
    }

    public String getTitle() {
        return this._title;
    }

    public String getURL() {
        return this._url;
    }
}

