/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.rss.web.internal.portlet.action;

import com.liferay.portal.kernel.portlet.ConfigurationAction;
import com.liferay.portal.kernel.portlet.DefaultConfigurationAction;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_rss_web_portlet_RSSPortlet"}, service={ConfigurationAction.class})
public class RSSConfigurationAction
extends DefaultConfigurationAction {
    public String getJspPath(HttpServletRequest request) {
        return "/configuration.jsp";
    }

    public void processAction(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        this.updateSubscriptions(actionRequest);
        super.processAction(portletConfig, actionRequest, actionResponse);
    }

    @Reference(target="(osgi.web.symbolicname=com.liferay.rss.web)", unbind="-")
    public void setServletContext(ServletContext servletContext) {
        super.setServletContext(servletContext);
    }

    protected void updateSubscriptions(ActionRequest actionRequest) throws Exception {
        int[] subscriptionIndexes = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"subscriptionIndexes"), (int)0);
        LinkedHashMap<String, String> subscriptions = new LinkedHashMap<String, String>();
        for (int subscriptionIndex : subscriptionIndexes) {
            String url = ParamUtil.getString((PortletRequest)actionRequest, (String)("url" + subscriptionIndex));
            String title = ParamUtil.getString((PortletRequest)actionRequest, (String)("title" + subscriptionIndex));
            if (Validator.isNull((String)url)) continue;
            subscriptions.put(url, title);
        }
        String[] urls = new String[subscriptions.size()];
        String[] titles = new String[subscriptions.size()];
        int i = 0;
        for (Map.Entry entry : subscriptions.entrySet()) {
            urls[i] = (String)entry.getKey();
            titles[i] = (String)entry.getValue();
            ++i;
        }
        this.setPreference((PortletRequest)actionRequest, "urls", urls);
        this.setPreference((PortletRequest)actionRequest, "titles", titles);
    }
}

