/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.rss.web.internal.display.context;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.rss.web.internal.configuration.RSSPortletInstanceConfiguration;
import com.liferay.rss.web.internal.configuration.RSSWebCacheConfiguration;
import com.liferay.rss.web.internal.util.RSSFeed;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class RSSDisplayContext {
    private long _displayStyleGroupId;
    private final HttpServletRequest _request;
    private final RSSPortletInstanceConfiguration _rssPortletInstanceConfiguration;
    private final RSSWebCacheConfiguration _rssWebCacheConfiguration;

    public RSSDisplayContext(HttpServletRequest request, RSSWebCacheConfiguration rssWebCacheConfiguration) throws ConfigurationException {
        this._request = request;
        this._rssWebCacheConfiguration = rssWebCacheConfiguration;
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        this._rssPortletInstanceConfiguration = (RSSPortletInstanceConfiguration)portletDisplay.getPortletInstanceConfiguration(RSSPortletInstanceConfiguration.class);
    }

    public long getDisplayStyleGroupId() {
        if (this._displayStyleGroupId != 0L) {
            return this._displayStyleGroupId;
        }
        this._displayStyleGroupId = this._rssPortletInstanceConfiguration.displayStyleGroupId();
        if (this._displayStyleGroupId <= 0L) {
            ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            this._displayStyleGroupId = themeDisplay.getScopeGroupId();
        }
        return this._displayStyleGroupId;
    }

    public List<RSSFeed> getRSSFeeds() {
        ArrayList<RSSFeed> rssFeeds = new ArrayList<RSSFeed>();
        String[] titles = this._rssPortletInstanceConfiguration.titles();
        String[] urls = this._rssPortletInstanceConfiguration.urls();
        for (int i = 0; i < urls.length; ++i) {
            String url = urls[i];
            String title = "";
            if (i < titles.length) {
                title = titles[i];
            }
            rssFeeds.add(new RSSFeed(this._rssWebCacheConfiguration, url, title));
        }
        return rssFeeds;
    }

    public RSSPortletInstanceConfiguration getRSSPortletInstanceConfiguration() {
        return this._rssPortletInstanceConfiguration;
    }

    public boolean isShowConfigurationLink() throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        return PortletPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (Layout)themeDisplay.getLayout(), (String)portletDisplay.getId(), (String)"CONFIGURATION");
    }
}

