/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.rss.internal.export;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.rss.export.RSSExporter;
import com.liferay.rss.internal.export.Normalizer;
import com.liferay.rss.model.SyndEntry;
import com.liferay.rss.model.SyndLink;
import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEnclosure;
import com.sun.syndication.feed.synd.SyndEnclosureImpl;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.feed.synd.SyndLinkImpl;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedOutput;
import java.util.ArrayList;
import java.util.List;
import org.jdom.IllegalDataException;
import org.osgi.service.component.annotations.Component;

@Component(service={RSSExporter.class})
public class RSSExporterImpl
implements RSSExporter {
    private static final String _REGEXP_STRIP = "[\\d\\w]";

    public String export(com.liferay.rss.model.SyndFeed syndFeed) {
        SyndFeed realSyndFeed = this._toRealSyndFeed(syndFeed);
        SyndFeedOutput output = new SyndFeedOutput();
        try {
            return output.outputString(realSyndFeed);
        }
        catch (IllegalDataException ide) {
            RSSExporterImpl._regexpStrip(realSyndFeed);
            try {
                return output.outputString(realSyndFeed);
            }
            catch (FeedException fe) {
                throw new SystemException((Throwable)fe);
            }
        }
        catch (FeedException fe) {
            throw new SystemException((Throwable)fe);
        }
    }

    private static void _regexpStrip(SyndFeed syndFeed) {
        syndFeed.setTitle(RSSExporterImpl._regexpStrip(syndFeed.getTitle()));
        syndFeed.setDescription(RSSExporterImpl._regexpStrip(syndFeed.getDescription()));
        List syndEntries = syndFeed.getEntries();
        for (com.sun.syndication.feed.synd.SyndEntry syndEntry : syndEntries) {
            syndEntry.setTitle(RSSExporterImpl._regexpStrip(syndEntry.getTitle()));
            SyndContent syndContent = syndEntry.getDescription();
            syndContent.setValue(RSSExporterImpl._regexpStrip(syndContent.getValue()));
        }
    }

    private static String _regexpStrip(String text) {
        text = Normalizer.normalizeToAscii(text);
        char[] array = text.toCharArray();
        for (int i = 0; i < array.length; ++i) {
            String s = String.valueOf(array[i]);
            if (s.matches(_REGEXP_STRIP)) continue;
            array[i] = 32;
        }
        return new String(array);
    }

    private SyndContent _toRealSyncContent(com.liferay.rss.model.SyndContent syndContent) {
        SyndContentImpl realSyndContent = new SyndContentImpl();
        realSyndContent.setType(syndContent.getType());
        realSyndContent.setValue(syndContent.getValue());
        return realSyndContent;
    }

    private List<SyndEnclosure> _toRealSyndEnclosures(List<com.liferay.rss.model.SyndEnclosure> syndEnclosures) {
        if (syndEnclosures == null) {
            return null;
        }
        ArrayList<SyndEnclosure> realSyndEnclosures = new ArrayList<SyndEnclosure>();
        for (com.liferay.rss.model.SyndEnclosure syndEnclosure : syndEnclosures) {
            SyndEnclosureImpl realSyndEnclosure = new SyndEnclosureImpl();
            realSyndEnclosure.setLength(syndEnclosure.getLength());
            realSyndEnclosure.setType(syndEnclosure.getType());
            realSyndEnclosure.setUrl(syndEnclosure.getUrl());
            realSyndEnclosures.add((SyndEnclosure)realSyndEnclosure);
        }
        return realSyndEnclosures;
    }

    private List<com.sun.syndication.feed.synd.SyndEntry> _toRealSyndEntries(List<SyndEntry> syndEntries) {
        if (syndEntries == null) {
            return null;
        }
        ArrayList<com.sun.syndication.feed.synd.SyndEntry> realSyndEntries = new ArrayList<com.sun.syndication.feed.synd.SyndEntry>();
        for (SyndEntry syndEntry : syndEntries) {
            SyndEntryImpl realSyndEntry = new SyndEntryImpl();
            realSyndEntry.setAuthor(syndEntry.getAuthor());
            realSyndEntry.setDescription(this._toRealSyncContent(syndEntry.getDescription()));
            realSyndEntry.setEnclosures(this._toRealSyndEnclosures(syndEntry.getEnclosures()));
            realSyndEntry.setLink(syndEntry.getLink());
            realSyndEntry.setLinks(this._toRealSyndLinks(syndEntry.getLinks()));
            realSyndEntry.setPublishedDate(syndEntry.getPublishedDate());
            realSyndEntry.setTitle(syndEntry.getTitle());
            realSyndEntry.setUpdatedDate(syndEntry.getUpdatedDate());
            realSyndEntry.setUri(syndEntry.getUri());
            realSyndEntries.add((com.sun.syndication.feed.synd.SyndEntry)realSyndEntry);
        }
        return realSyndEntries;
    }

    private SyndFeed _toRealSyndFeed(com.liferay.rss.model.SyndFeed syndFeed) {
        SyndFeedImpl realSyndFeed = new SyndFeedImpl();
        realSyndFeed.setDescription(syndFeed.getDescription());
        realSyndFeed.setEntries(this._toRealSyndEntries(syndFeed.getEntries()));
        realSyndFeed.setFeedType(syndFeed.getFeedType());
        realSyndFeed.setLinks(this._toRealSyndLinks(syndFeed.getLinks()));
        realSyndFeed.setPublishedDate(syndFeed.getPublishedDate());
        realSyndFeed.setTitle(syndFeed.getTitle());
        realSyndFeed.setUri(syndFeed.getUri());
        return realSyndFeed;
    }

    private List<com.sun.syndication.feed.synd.SyndLink> _toRealSyndLinks(List<SyndLink> syndLinks) {
        if (syndLinks == null) {
            return null;
        }
        ArrayList<com.sun.syndication.feed.synd.SyndLink> realSyndLinks = new ArrayList<com.sun.syndication.feed.synd.SyndLink>();
        for (SyndLink syndLink : syndLinks) {
            SyndLinkImpl realSyndLink = new SyndLinkImpl();
            realSyndLink.setHref(syndLink.getHref());
            realSyndLink.setLength(syndLink.getLength());
            realSyndLink.setRel(syndLink.getRel());
            realSyndLink.setType(syndLink.getType());
            realSyndLinks.add((com.sun.syndication.feed.synd.SyndLink)realSyndLink);
        }
        return realSyndLinks;
    }
}

