Liferay.Loader.define('roles-admin-web$lodash-es@4.17.15/defer', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  import baseDelay from './_baseDelay.js';
  import baseRest from './_baseRest.js';

  /**
   * Defers invoking the `func` until the current call stack has cleared. Any
   * additional arguments are provided to `func` when it's invoked.
   *
   * @static
   * @memberOf _
   * @since 0.1.0
   * @category Function
   * @param {Function} func The function to defer.
   * @param {...*} [args] The arguments to invoke `func` with.
   * @returns {number} Returns the timer id.
   * @example
   *
   * _.defer(function(text) {
   *   console.log(text);
   * }, 'deferred');
   * // => Logs 'deferred' after one millisecond.
   */
  var defer = baseRest(function (func, args) {
    return baseDelay(func, 1, args);
  });

  export default defer;
});
//# sourceMappingURL=defer.js.map